/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostResourceStatistics;
import com.oracle.bmc.opsi.model.SummaryStatistics;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceName")
@JsonFilter(value="explicitlySetFilter")
public final class HostCpuStatistics
extends HostResourceStatistics {
    @JsonProperty(value="load")
    private final SummaryStatistics load;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostCpuStatistics(Double usage, Double capacity, Double utilizationPercent, Double usageChangePercent, SummaryStatistics load) {
        super(usage, capacity, utilizationPercent, usageChangePercent);
        this.load = load;
    }

    public SummaryStatistics getLoad() {
        return this.load;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostCpuStatistics(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", load=").append(String.valueOf((Object)this.load));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostCpuStatistics)) {
            return false;
        }
        HostCpuStatistics other = (HostCpuStatistics)((Object)o);
        return Objects.equals((Object)this.load, (Object)other.load) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.load == null ? 43 : this.load.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="usage")
        private Double usage;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="utilizationPercent")
        private Double utilizationPercent;
        @JsonProperty(value="usageChangePercent")
        private Double usageChangePercent;
        @JsonProperty(value="load")
        private SummaryStatistics load;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder usage(Double usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder utilizationPercent(Double utilizationPercent) {
            this.utilizationPercent = utilizationPercent;
            this.__explicitlySet__.add("utilizationPercent");
            return this;
        }

        public Builder usageChangePercent(Double usageChangePercent) {
            this.usageChangePercent = usageChangePercent;
            this.__explicitlySet__.add("usageChangePercent");
            return this;
        }

        public Builder load(SummaryStatistics load) {
            this.load = load;
            this.__explicitlySet__.add("load");
            return this;
        }

        public HostCpuStatistics build() {
            HostCpuStatistics model = new HostCpuStatistics(this.usage, this.capacity, this.utilizationPercent, this.usageChangePercent, this.load);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostCpuStatistics model) {
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("utilizationPercent")) {
                this.utilizationPercent(model.getUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("usageChangePercent")) {
                this.usageChangePercent(model.getUsageChangePercent());
            }
            if (model.wasPropertyExplicitlySet("load")) {
                this.load(model.getLoad());
            }
            return this;
        }
    }
}

