/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="hostDisplayName")
    private final String hostDisplayName;
    @JsonProperty(value="platformType")
    private final PlatformType platformType;
    @JsonProperty(value="agentIdentifier")
    private final String agentIdentifier;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "hostName", "hostDisplayName", "platformType", "agentIdentifier"})
    public HostDetails(String id, String compartmentId, String hostName, String hostDisplayName, PlatformType platformType, String agentIdentifier) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.hostName = hostName;
        this.hostDisplayName = hostDisplayName;
        this.platformType = platformType;
        this.agentIdentifier = agentIdentifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostDisplayName() {
        return this.hostDisplayName;
    }

    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public String getAgentIdentifier() {
        return this.agentIdentifier;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostDetails(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", hostName=").append(String.valueOf(this.hostName));
        sb.append(", hostDisplayName=").append(String.valueOf(this.hostDisplayName));
        sb.append(", platformType=").append(String.valueOf((Object)this.platformType));
        sb.append(", agentIdentifier=").append(String.valueOf(this.agentIdentifier));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostDetails)) {
            return false;
        }
        HostDetails other = (HostDetails)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.hostDisplayName, other.hostDisplayName) && Objects.equals((Object)this.platformType, (Object)other.platformType) && Objects.equals(this.agentIdentifier, other.agentIdentifier) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.hostDisplayName == null ? 43 : this.hostDisplayName.hashCode());
        result = result * 59 + (this.platformType == null ? 43 : this.platformType.hashCode());
        result = result * 59 + (this.agentIdentifier == null ? 43 : this.agentIdentifier.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PlatformType implements BmcEnum
    {
        Linux("LINUX"),
        Solaris("SOLARIS"),
        Sunos("SUNOS"),
        Zlinux("ZLINUX"),
        Windows("WINDOWS"),
        Aix("AIX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlatformType> map;

        private PlatformType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlatformType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlatformType.class);
            map = new HashMap<String, PlatformType>();
            for (PlatformType v : PlatformType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="hostDisplayName")
        private String hostDisplayName;
        @JsonProperty(value="platformType")
        private PlatformType platformType;
        @JsonProperty(value="agentIdentifier")
        private String agentIdentifier;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder hostDisplayName(String hostDisplayName) {
            this.hostDisplayName = hostDisplayName;
            this.__explicitlySet__.add("hostDisplayName");
            return this;
        }

        public Builder platformType(PlatformType platformType) {
            this.platformType = platformType;
            this.__explicitlySet__.add("platformType");
            return this;
        }

        public Builder agentIdentifier(String agentIdentifier) {
            this.agentIdentifier = agentIdentifier;
            this.__explicitlySet__.add("agentIdentifier");
            return this;
        }

        public HostDetails build() {
            HostDetails model = new HostDetails(this.id, this.compartmentId, this.hostName, this.hostDisplayName, this.platformType, this.agentIdentifier);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostDetails model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("hostDisplayName")) {
                this.hostDisplayName(model.getHostDisplayName());
            }
            if (model.wasPropertyExplicitlySet("platformType")) {
                this.platformType(model.getPlatformType());
            }
            if (model.wasPropertyExplicitlySet("agentIdentifier")) {
                this.agentIdentifier(model.getAgentIdentifier());
            }
            return this;
        }
    }
}

