/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostFilesystemConfiguration
extends HostConfigurationMetricGroup {
    @JsonProperty(value="fileSystemName")
    private final String fileSystemName;
    @JsonProperty(value="mountPoint")
    private final String mountPoint;
    @JsonProperty(value="fileSystemSizeInGB")
    private final Double fileSystemSizeInGB;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostFilesystemConfiguration(Date timeCollected, String fileSystemName, String mountPoint, Double fileSystemSizeInGB) {
        super(timeCollected);
        this.fileSystemName = fileSystemName;
        this.mountPoint = mountPoint;
        this.fileSystemSizeInGB = fileSystemSizeInGB;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public Double getFileSystemSizeInGB() {
        return this.fileSystemSizeInGB;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostFilesystemConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", fileSystemName=").append(String.valueOf(this.fileSystemName));
        sb.append(", mountPoint=").append(String.valueOf(this.mountPoint));
        sb.append(", fileSystemSizeInGB=").append(String.valueOf(this.fileSystemSizeInGB));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostFilesystemConfiguration)) {
            return false;
        }
        HostFilesystemConfiguration other = (HostFilesystemConfiguration)((Object)o);
        return Objects.equals(this.fileSystemName, other.fileSystemName) && Objects.equals(this.mountPoint, other.mountPoint) && Objects.equals(this.fileSystemSizeInGB, other.fileSystemSizeInGB) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fileSystemName == null ? 43 : this.fileSystemName.hashCode());
        result = result * 59 + (this.mountPoint == null ? 43 : this.mountPoint.hashCode());
        result = result * 59 + (this.fileSystemSizeInGB == null ? 43 : this.fileSystemSizeInGB.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="fileSystemName")
        private String fileSystemName;
        @JsonProperty(value="mountPoint")
        private String mountPoint;
        @JsonProperty(value="fileSystemSizeInGB")
        private Double fileSystemSizeInGB;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder fileSystemName(String fileSystemName) {
            this.fileSystemName = fileSystemName;
            this.__explicitlySet__.add("fileSystemName");
            return this;
        }

        public Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            this.__explicitlySet__.add("mountPoint");
            return this;
        }

        public Builder fileSystemSizeInGB(Double fileSystemSizeInGB) {
            this.fileSystemSizeInGB = fileSystemSizeInGB;
            this.__explicitlySet__.add("fileSystemSizeInGB");
            return this;
        }

        public HostFilesystemConfiguration build() {
            HostFilesystemConfiguration model = new HostFilesystemConfiguration(this.timeCollected, this.fileSystemName, this.mountPoint, this.fileSystemSizeInGB);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostFilesystemConfiguration model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("fileSystemName")) {
                this.fileSystemName(model.getFileSystemName());
            }
            if (model.wasPropertyExplicitlySet("mountPoint")) {
                this.mountPoint(model.getMountPoint());
            }
            if (model.wasPropertyExplicitlySet("fileSystemSizeInGB")) {
                this.fileSystemSizeInGB(model.getFileSystemSizeInGB());
            }
            return this;
        }
    }
}

