/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostInstanceMap
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="instanceName")
    private final String instanceName;

    @Deprecated
    @ConstructorProperties(value={"hostName", "instanceName"})
    public HostInstanceMap(String hostName, String instanceName) {
        this.hostName = hostName;
        this.instanceName = instanceName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostInstanceMap(");
        sb.append("super=").append(super.toString());
        sb.append("hostName=").append(String.valueOf(this.hostName));
        sb.append(", instanceName=").append(String.valueOf(this.instanceName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostInstanceMap)) {
            return false;
        }
        HostInstanceMap other = (HostInstanceMap)((Object)o);
        return Objects.equals(this.hostName, other.hostName) && Objects.equals(this.instanceName, other.instanceName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public HostInstanceMap build() {
            HostInstanceMap model = new HostInstanceMap(this.hostName, this.instanceName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostInstanceMap model) {
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            return this;
        }
    }
}

