/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostNetworkConfiguration
extends HostConfigurationMetricGroup {
    @JsonProperty(value="interfaceName")
    private final String interfaceName;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="macAddress")
    private final String macAddress;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostNetworkConfiguration(Date timeCollected, String interfaceName, String ipAddress, String macAddress) {
        super(timeCollected);
        this.interfaceName = interfaceName;
        this.ipAddress = ipAddress;
        this.macAddress = macAddress;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostNetworkConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", interfaceName=").append(String.valueOf(this.interfaceName));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", macAddress=").append(String.valueOf(this.macAddress));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostNetworkConfiguration)) {
            return false;
        }
        HostNetworkConfiguration other = (HostNetworkConfiguration)((Object)o);
        return Objects.equals(this.interfaceName, other.interfaceName) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.macAddress, other.macAddress) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.interfaceName == null ? 43 : this.interfaceName.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.macAddress == null ? 43 : this.macAddress.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="interfaceName")
        private String interfaceName;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="macAddress")
        private String macAddress;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder interfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
            this.__explicitlySet__.add("interfaceName");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            this.__explicitlySet__.add("macAddress");
            return this;
        }

        public HostNetworkConfiguration build() {
            HostNetworkConfiguration model = new HostNetworkConfiguration(this.timeCollected, this.interfaceName, this.ipAddress, this.macAddress);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostNetworkConfiguration model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("interfaceName")) {
                this.interfaceName(model.getInterfaceName());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("macAddress")) {
                this.macAddress(model.getMacAddress());
            }
            return this;
        }
    }
}

