/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.HostInsight;
import com.oracle.bmc.opsi.model.LifecycleState;
import com.oracle.bmc.opsi.model.ResourceStatus;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entitySource")
@JsonFilter(value="explicitlySetFilter")
public final class MacsManagedExternalHostInsight
extends HostInsight {
    @JsonProperty(value="managementAgentId")
    private final String managementAgentId;
    @JsonProperty(value="platformName")
    private final String platformName;
    @JsonProperty(value="platformType")
    private final PlatformType platformType;
    @JsonProperty(value="platformVersion")
    private final String platformVersion;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public MacsManagedExternalHostInsight(String id, String compartmentId, String hostName, String hostDisplayName, String hostType, Integer processorCount, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, ResourceStatus status, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecycleDetails, String managementAgentId, String platformName, PlatformType platformType, String platformVersion) {
        super(id, compartmentId, hostName, hostDisplayName, hostType, processorCount, freeformTags, definedTags, systemTags, status, timeCreated, timeUpdated, lifecycleState, lifecycleDetails);
        this.managementAgentId = managementAgentId;
        this.platformName = platformName;
        this.platformType = platformType;
        this.platformVersion = platformVersion;
    }

    public String getManagementAgentId() {
        return this.managementAgentId;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MacsManagedExternalHostInsight(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", managementAgentId=").append(String.valueOf(this.managementAgentId));
        sb.append(", platformName=").append(String.valueOf(this.platformName));
        sb.append(", platformType=").append(String.valueOf((Object)this.platformType));
        sb.append(", platformVersion=").append(String.valueOf(this.platformVersion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MacsManagedExternalHostInsight)) {
            return false;
        }
        MacsManagedExternalHostInsight other = (MacsManagedExternalHostInsight)((Object)o);
        return Objects.equals(this.managementAgentId, other.managementAgentId) && Objects.equals(this.platformName, other.platformName) && Objects.equals((Object)this.platformType, (Object)other.platformType) && Objects.equals(this.platformVersion, other.platformVersion) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managementAgentId == null ? 43 : this.managementAgentId.hashCode());
        result = result * 59 + (this.platformName == null ? 43 : this.platformName.hashCode());
        result = result * 59 + (this.platformType == null ? 43 : this.platformType.hashCode());
        result = result * 59 + (this.platformVersion == null ? 43 : this.platformVersion.hashCode());
        return result;
    }

    public static enum PlatformType implements BmcEnum
    {
        Linux("LINUX"),
        Solaris("SOLARIS"),
        Sunos("SUNOS"),
        Zlinux("ZLINUX"),
        Windows("WINDOWS"),
        Aix("AIX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlatformType> map;

        private PlatformType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlatformType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlatformType.class);
            map = new HashMap<String, PlatformType>();
            for (PlatformType v : PlatformType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="hostDisplayName")
        private String hostDisplayName;
        @JsonProperty(value="hostType")
        private String hostType;
        @JsonProperty(value="processorCount")
        private Integer processorCount;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="status")
        private ResourceStatus status;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="managementAgentId")
        private String managementAgentId;
        @JsonProperty(value="platformName")
        private String platformName;
        @JsonProperty(value="platformType")
        private PlatformType platformType;
        @JsonProperty(value="platformVersion")
        private String platformVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder hostDisplayName(String hostDisplayName) {
            this.hostDisplayName = hostDisplayName;
            this.__explicitlySet__.add("hostDisplayName");
            return this;
        }

        public Builder hostType(String hostType) {
            this.hostType = hostType;
            this.__explicitlySet__.add("hostType");
            return this;
        }

        public Builder processorCount(Integer processorCount) {
            this.processorCount = processorCount;
            this.__explicitlySet__.add("processorCount");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder status(ResourceStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder managementAgentId(String managementAgentId) {
            this.managementAgentId = managementAgentId;
            this.__explicitlySet__.add("managementAgentId");
            return this;
        }

        public Builder platformName(String platformName) {
            this.platformName = platformName;
            this.__explicitlySet__.add("platformName");
            return this;
        }

        public Builder platformType(PlatformType platformType) {
            this.platformType = platformType;
            this.__explicitlySet__.add("platformType");
            return this;
        }

        public Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            this.__explicitlySet__.add("platformVersion");
            return this;
        }

        public MacsManagedExternalHostInsight build() {
            MacsManagedExternalHostInsight model = new MacsManagedExternalHostInsight(this.id, this.compartmentId, this.hostName, this.hostDisplayName, this.hostType, this.processorCount, this.freeformTags, this.definedTags, this.systemTags, this.status, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.managementAgentId, this.platformName, this.platformType, this.platformVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MacsManagedExternalHostInsight model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("hostDisplayName")) {
                this.hostDisplayName(model.getHostDisplayName());
            }
            if (model.wasPropertyExplicitlySet("hostType")) {
                this.hostType(model.getHostType());
            }
            if (model.wasPropertyExplicitlySet("processorCount")) {
                this.processorCount(model.getProcessorCount());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("managementAgentId")) {
                this.managementAgentId(model.getManagementAgentId());
            }
            if (model.wasPropertyExplicitlySet("platformName")) {
                this.platformName(model.getPlatformName());
            }
            if (model.wasPropertyExplicitlySet("platformType")) {
                this.platformType(model.getPlatformType());
            }
            if (model.wasPropertyExplicitlySet("platformVersion")) {
                this.platformVersion(model.getPlatformVersion());
            }
            return this;
        }
    }
}

