/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.RelatedObjectTypeDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class SchemaObjectTypeDetails
extends RelatedObjectTypeDetails {
    @JsonProperty(value="objectId")
    private final Integer objectId;
    @JsonProperty(value="owner")
    private final String owner;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="subObjectName")
    private final String subObjectName;
    @JsonProperty(value="objectType")
    private final String objectType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SchemaObjectTypeDetails(Integer objectId, String owner, String objectName, String subObjectName, String objectType) {
        this.objectId = objectId;
        this.owner = owner;
        this.objectName = objectName;
        this.subObjectName = subObjectName;
        this.objectType = objectType;
    }

    public Integer getObjectId() {
        return this.objectId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getSubObjectName() {
        return this.subObjectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SchemaObjectTypeDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", objectId=").append(String.valueOf(this.objectId));
        sb.append(", owner=").append(String.valueOf(this.owner));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", subObjectName=").append(String.valueOf(this.subObjectName));
        sb.append(", objectType=").append(String.valueOf(this.objectType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaObjectTypeDetails)) {
            return false;
        }
        SchemaObjectTypeDetails other = (SchemaObjectTypeDetails)((Object)o);
        return Objects.equals(this.objectId, other.objectId) && Objects.equals(this.owner, other.owner) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.subObjectName, other.subObjectName) && Objects.equals(this.objectType, other.objectType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.objectId == null ? 43 : this.objectId.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.subObjectName == null ? 43 : this.subObjectName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objectId")
        private Integer objectId;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="subObjectName")
        private String subObjectName;
        @JsonProperty(value="objectType")
        private String objectType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objectId(Integer objectId) {
            this.objectId = objectId;
            this.__explicitlySet__.add("objectId");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder subObjectName(String subObjectName) {
            this.subObjectName = subObjectName;
            this.__explicitlySet__.add("subObjectName");
            return this;
        }

        public Builder objectType(String objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public SchemaObjectTypeDetails build() {
            SchemaObjectTypeDetails model = new SchemaObjectTypeDetails(this.objectId, this.owner, this.objectName, this.subObjectName, this.objectType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SchemaObjectTypeDetails model) {
            if (model.wasPropertyExplicitlySet("objectId")) {
                this.objectId(model.getObjectId());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("subObjectName")) {
                this.subObjectName(model.getSubObjectName());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            return this;
        }
    }
}

