/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.DataObjectType;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListWarehouseDataObjectsRequest
extends BmcRequest<Void> {
    private WarehouseType warehouseType;
    private String warehouseId;
    private List<DataObjectType> dataObjectType;
    private String name;
    private String owner;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private List<SummaryField> summaryField;
    private String opcRequestId;

    public WarehouseType getWarehouseType() {
        return this.warehouseType;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public List<DataObjectType> getDataObjectType() {
        return this.dataObjectType;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<SummaryField> getSummaryField() {
        return this.summaryField;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().warehouseType(this.warehouseType).warehouseId(this.warehouseId).dataObjectType(this.dataObjectType).name(this.name).owner(this.owner).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).summaryField(this.summaryField).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",warehouseType=").append(String.valueOf((Object)this.warehouseType));
        sb.append(",warehouseId=").append(String.valueOf(this.warehouseId));
        sb.append(",dataObjectType=").append(String.valueOf(this.dataObjectType));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",owner=").append(String.valueOf(this.owner));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",summaryField=").append(String.valueOf(this.summaryField));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWarehouseDataObjectsRequest)) {
            return false;
        }
        ListWarehouseDataObjectsRequest other = (ListWarehouseDataObjectsRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.warehouseType, (Object)other.warehouseType) && Objects.equals(this.warehouseId, other.warehouseId) && Objects.equals(this.dataObjectType, other.dataObjectType) && Objects.equals(this.name, other.name) && Objects.equals(this.owner, other.owner) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.summaryField, other.summaryField) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.warehouseType == null ? 43 : this.warehouseType.hashCode());
        result = result * 59 + (this.warehouseId == null ? 43 : this.warehouseId.hashCode());
        result = result * 59 + (this.dataObjectType == null ? 43 : this.dataObjectType.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.summaryField == null ? 43 : this.summaryField.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWarehouseDataObjectsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private WarehouseType warehouseType = null;
        private String warehouseId = null;
        private List<DataObjectType> dataObjectType = null;
        private String name = null;
        private String owner = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private List<SummaryField> summaryField = null;
        private String opcRequestId = null;

        public Builder warehouseType(WarehouseType warehouseType) {
            this.warehouseType = warehouseType;
            return this;
        }

        public Builder warehouseId(String warehouseId) {
            this.warehouseId = warehouseId;
            return this;
        }

        public Builder dataObjectType(List<DataObjectType> dataObjectType) {
            this.dataObjectType = dataObjectType;
            return this;
        }

        public Builder dataObjectType(DataObjectType singularValue) {
            return this.dataObjectType(Arrays.asList(singularValue));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder summaryField(List<SummaryField> summaryField) {
            this.summaryField = summaryField;
            return this;
        }

        public Builder summaryField(SummaryField singularValue) {
            return this.summaryField(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWarehouseDataObjectsRequest o) {
            this.warehouseType(o.getWarehouseType());
            this.warehouseId(o.getWarehouseId());
            this.dataObjectType(o.getDataObjectType());
            this.name(o.getName());
            this.owner(o.getOwner());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.summaryField(o.getSummaryField());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWarehouseDataObjectsRequest build() {
            ListWarehouseDataObjectsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWarehouseDataObjectsRequest buildWithoutInvocationCallback() {
            ListWarehouseDataObjectsRequest request = new ListWarehouseDataObjectsRequest();
            request.warehouseType = this.warehouseType;
            request.warehouseId = this.warehouseId;
            request.dataObjectType = this.dataObjectType;
            request.name = this.name;
            request.owner = this.owner;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.summaryField = this.summaryField;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SummaryField implements BmcEnum
    {
        Details("details");

        private final String value;
        private static Map<String, SummaryField> map;

        private SummaryField(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SummaryField create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SummaryField: " + key);
        }

        static {
            map = new HashMap<String, SummaryField>();
            for (SummaryField v : SummaryField.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DataObjectType("dataObjectType"),
        Name("name"),
        Owner("owner");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum WarehouseType implements BmcEnum
    {
        AwrHubs("awrHubs");

        private final String value;
        private static Map<String, WarehouseType> map;

        private WarehouseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WarehouseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WarehouseType: " + key);
        }

        static {
            map = new HashMap<String, WarehouseType>();
            for (WarehouseType v : WarehouseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

