/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.QueryWarehouseDataObjectDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class QueryWarehouseDataObjectDataRequest
extends BmcRequest<QueryWarehouseDataObjectDataDetails> {
    private WarehouseType warehouseType;
    private String warehouseId;
    private QueryWarehouseDataObjectDataDetails queryWarehouseDataObjectDataDetails;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public WarehouseType getWarehouseType() {
        return this.warehouseType;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public QueryWarehouseDataObjectDataDetails getQueryWarehouseDataObjectDataDetails() {
        return this.queryWarehouseDataObjectDataDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public QueryWarehouseDataObjectDataDetails getBody$() {
        return this.queryWarehouseDataObjectDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().warehouseType(this.warehouseType).warehouseId(this.warehouseId).queryWarehouseDataObjectDataDetails(this.queryWarehouseDataObjectDataDetails).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",warehouseType=").append(String.valueOf((Object)this.warehouseType));
        sb.append(",warehouseId=").append(String.valueOf(this.warehouseId));
        sb.append(",queryWarehouseDataObjectDataDetails=").append(String.valueOf((Object)this.queryWarehouseDataObjectDataDetails));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryWarehouseDataObjectDataRequest)) {
            return false;
        }
        QueryWarehouseDataObjectDataRequest other = (QueryWarehouseDataObjectDataRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.warehouseType, (Object)other.warehouseType) && Objects.equals(this.warehouseId, other.warehouseId) && Objects.equals((Object)this.queryWarehouseDataObjectDataDetails, (Object)other.queryWarehouseDataObjectDataDetails) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.warehouseType == null ? 43 : this.warehouseType.hashCode());
        result = result * 59 + (this.warehouseId == null ? 43 : this.warehouseId.hashCode());
        result = result * 59 + (this.queryWarehouseDataObjectDataDetails == null ? 43 : this.queryWarehouseDataObjectDataDetails.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<QueryWarehouseDataObjectDataRequest, QueryWarehouseDataObjectDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private WarehouseType warehouseType = null;
        private String warehouseId = null;
        private QueryWarehouseDataObjectDataDetails queryWarehouseDataObjectDataDetails = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder warehouseType(WarehouseType warehouseType) {
            this.warehouseType = warehouseType;
            return this;
        }

        public Builder warehouseId(String warehouseId) {
            this.warehouseId = warehouseId;
            return this;
        }

        public Builder queryWarehouseDataObjectDataDetails(QueryWarehouseDataObjectDataDetails queryWarehouseDataObjectDataDetails) {
            this.queryWarehouseDataObjectDataDetails = queryWarehouseDataObjectDataDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(QueryWarehouseDataObjectDataRequest o) {
            this.warehouseType(o.getWarehouseType());
            this.warehouseId(o.getWarehouseId());
            this.queryWarehouseDataObjectDataDetails(o.getQueryWarehouseDataObjectDataDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public QueryWarehouseDataObjectDataRequest build() {
            QueryWarehouseDataObjectDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(QueryWarehouseDataObjectDataDetails body) {
            this.queryWarehouseDataObjectDataDetails(body);
            return this;
        }

        public QueryWarehouseDataObjectDataRequest buildWithoutInvocationCallback() {
            QueryWarehouseDataObjectDataRequest request = new QueryWarehouseDataObjectDataRequest();
            request.warehouseType = this.warehouseType;
            request.warehouseId = this.warehouseId;
            request.queryWarehouseDataObjectDataDetails = this.queryWarehouseDataObjectDataDetails;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum WarehouseType implements BmcEnum
    {
        AwrHubs("awrHubs");

        private final String value;
        private static Map<String, WarehouseType> map;

        private WarehouseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WarehouseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WarehouseType: " + key);
        }

        static {
            map = new HashMap<String, WarehouseType>();
            for (WarehouseType v : WarehouseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

