/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeDatabaseInsightResourceCapacityTrendRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceMetric;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private List<DatabaseType> databaseType;
    private List<String> databaseId;
    private List<String> id;
    private List<String> exadataInsightId;
    private List<String> cdbName;
    private UtilizationLevel utilizationLevel;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String tablespaceName;
    private List<String> hostName;
    private Boolean isDatabaseInstanceLevelMetrics;
    private String opcRequestId;
    private List<String> definedTagEquals;
    private List<String> freeformTagEquals;
    private List<String> definedTagExists;
    private List<String> freeformTagExists;
    private Boolean compartmentIdInSubtree;
    private List<String> vmclusterName;
    private Integer highUtilizationThreshold;
    private Integer lowUtilizationThreshold;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceMetric() {
        return this.resourceMetric;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public List<DatabaseType> getDatabaseType() {
        return this.databaseType;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public List<String> getId() {
        return this.id;
    }

    public List<String> getExadataInsightId() {
        return this.exadataInsightId;
    }

    public List<String> getCdbName() {
        return this.cdbName;
    }

    public UtilizationLevel getUtilizationLevel() {
        return this.utilizationLevel;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public List<String> getHostName() {
        return this.hostName;
    }

    public Boolean getIsDatabaseInstanceLevelMetrics() {
        return this.isDatabaseInstanceLevelMetrics;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getDefinedTagEquals() {
        return this.definedTagEquals;
    }

    public List<String> getFreeformTagEquals() {
        return this.freeformTagEquals;
    }

    public List<String> getDefinedTagExists() {
        return this.definedTagExists;
    }

    public List<String> getFreeformTagExists() {
        return this.freeformTagExists;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public List<String> getVmclusterName() {
        return this.vmclusterName;
    }

    public Integer getHighUtilizationThreshold() {
        return this.highUtilizationThreshold;
    }

    public Integer getLowUtilizationThreshold() {
        return this.lowUtilizationThreshold;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).resourceMetric(this.resourceMetric).analysisTimeInterval(this.analysisTimeInterval).timeIntervalStart(this.timeIntervalStart).timeIntervalEnd(this.timeIntervalEnd).databaseType(this.databaseType).databaseId(this.databaseId).id(this.id).exadataInsightId(this.exadataInsightId).cdbName(this.cdbName).utilizationLevel(this.utilizationLevel).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).tablespaceName(this.tablespaceName).hostName(this.hostName).isDatabaseInstanceLevelMetrics(this.isDatabaseInstanceLevelMetrics).opcRequestId(this.opcRequestId).definedTagEquals(this.definedTagEquals).freeformTagEquals(this.freeformTagEquals).definedTagExists(this.definedTagExists).freeformTagExists(this.freeformTagExists).compartmentIdInSubtree(this.compartmentIdInSubtree).vmclusterName(this.vmclusterName).highUtilizationThreshold(this.highUtilizationThreshold).lowUtilizationThreshold(this.lowUtilizationThreshold);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",resourceMetric=").append(String.valueOf(this.resourceMetric));
        sb.append(",analysisTimeInterval=").append(String.valueOf(this.analysisTimeInterval));
        sb.append(",timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(",timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(",databaseType=").append(String.valueOf(this.databaseType));
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",exadataInsightId=").append(String.valueOf(this.exadataInsightId));
        sb.append(",cdbName=").append(String.valueOf(this.cdbName));
        sb.append(",utilizationLevel=").append(String.valueOf((Object)this.utilizationLevel));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",tablespaceName=").append(String.valueOf(this.tablespaceName));
        sb.append(",hostName=").append(String.valueOf(this.hostName));
        sb.append(",isDatabaseInstanceLevelMetrics=").append(String.valueOf(this.isDatabaseInstanceLevelMetrics));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",definedTagEquals=").append(String.valueOf(this.definedTagEquals));
        sb.append(",freeformTagEquals=").append(String.valueOf(this.freeformTagEquals));
        sb.append(",definedTagExists=").append(String.valueOf(this.definedTagExists));
        sb.append(",freeformTagExists=").append(String.valueOf(this.freeformTagExists));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",vmclusterName=").append(String.valueOf(this.vmclusterName));
        sb.append(",highUtilizationThreshold=").append(String.valueOf(this.highUtilizationThreshold));
        sb.append(",lowUtilizationThreshold=").append(String.valueOf(this.lowUtilizationThreshold));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeDatabaseInsightResourceCapacityTrendRequest)) {
            return false;
        }
        SummarizeDatabaseInsightResourceCapacityTrendRequest other = (SummarizeDatabaseInsightResourceCapacityTrendRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceMetric, other.resourceMetric) && Objects.equals(this.analysisTimeInterval, other.analysisTimeInterval) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.databaseType, other.databaseType) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.id, other.id) && Objects.equals(this.exadataInsightId, other.exadataInsightId) && Objects.equals(this.cdbName, other.cdbName) && Objects.equals((Object)this.utilizationLevel, (Object)other.utilizationLevel) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.tablespaceName, other.tablespaceName) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.isDatabaseInstanceLevelMetrics, other.isDatabaseInstanceLevelMetrics) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.definedTagEquals, other.definedTagEquals) && Objects.equals(this.freeformTagEquals, other.freeformTagEquals) && Objects.equals(this.definedTagExists, other.definedTagExists) && Objects.equals(this.freeformTagExists, other.freeformTagExists) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.vmclusterName, other.vmclusterName) && Objects.equals(this.highUtilizationThreshold, other.highUtilizationThreshold) && Objects.equals(this.lowUtilizationThreshold, other.lowUtilizationThreshold);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceMetric == null ? 43 : this.resourceMetric.hashCode());
        result = result * 59 + (this.analysisTimeInterval == null ? 43 : this.analysisTimeInterval.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.exadataInsightId == null ? 43 : this.exadataInsightId.hashCode());
        result = result * 59 + (this.cdbName == null ? 43 : this.cdbName.hashCode());
        result = result * 59 + (this.utilizationLevel == null ? 43 : this.utilizationLevel.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.tablespaceName == null ? 43 : this.tablespaceName.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.isDatabaseInstanceLevelMetrics == null ? 43 : this.isDatabaseInstanceLevelMetrics.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.definedTagEquals == null ? 43 : this.definedTagEquals.hashCode());
        result = result * 59 + (this.freeformTagEquals == null ? 43 : this.freeformTagEquals.hashCode());
        result = result * 59 + (this.definedTagExists == null ? 43 : this.definedTagExists.hashCode());
        result = result * 59 + (this.freeformTagExists == null ? 43 : this.freeformTagExists.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.vmclusterName == null ? 43 : this.vmclusterName.hashCode());
        result = result * 59 + (this.highUtilizationThreshold == null ? 43 : this.highUtilizationThreshold.hashCode());
        result = result * 59 + (this.lowUtilizationThreshold == null ? 43 : this.lowUtilizationThreshold.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeDatabaseInsightResourceCapacityTrendRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String resourceMetric = null;
        private String analysisTimeInterval = null;
        private Date timeIntervalStart = null;
        private Date timeIntervalEnd = null;
        private List<DatabaseType> databaseType = null;
        private List<String> databaseId = null;
        private List<String> id = null;
        private List<String> exadataInsightId = null;
        private List<String> cdbName = null;
        private UtilizationLevel utilizationLevel = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String tablespaceName = null;
        private List<String> hostName = null;
        private Boolean isDatabaseInstanceLevelMetrics = null;
        private String opcRequestId = null;
        private List<String> definedTagEquals = null;
        private List<String> freeformTagEquals = null;
        private List<String> definedTagExists = null;
        private List<String> freeformTagExists = null;
        private Boolean compartmentIdInSubtree = null;
        private List<String> vmclusterName = null;
        private Integer highUtilizationThreshold = null;
        private Integer lowUtilizationThreshold = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceMetric(String resourceMetric) {
            this.resourceMetric = resourceMetric;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder databaseType(List<DatabaseType> databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder databaseType(DatabaseType singularValue) {
            return this.databaseType(Arrays.asList(singularValue));
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder databaseId(String singularValue) {
            return this.databaseId(Arrays.asList(singularValue));
        }

        public Builder id(List<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String singularValue) {
            return this.id(Arrays.asList(singularValue));
        }

        public Builder exadataInsightId(List<String> exadataInsightId) {
            this.exadataInsightId = exadataInsightId;
            return this;
        }

        public Builder exadataInsightId(String singularValue) {
            return this.exadataInsightId(Arrays.asList(singularValue));
        }

        public Builder cdbName(List<String> cdbName) {
            this.cdbName = cdbName;
            return this;
        }

        public Builder cdbName(String singularValue) {
            return this.cdbName(Arrays.asList(singularValue));
        }

        public Builder utilizationLevel(UtilizationLevel utilizationLevel) {
            this.utilizationLevel = utilizationLevel;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder tablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
            return this;
        }

        public Builder hostName(List<String> hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder hostName(String singularValue) {
            return this.hostName(Arrays.asList(singularValue));
        }

        public Builder isDatabaseInstanceLevelMetrics(Boolean isDatabaseInstanceLevelMetrics) {
            this.isDatabaseInstanceLevelMetrics = isDatabaseInstanceLevelMetrics;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder definedTagEquals(List<String> definedTagEquals) {
            this.definedTagEquals = definedTagEquals;
            return this;
        }

        public Builder definedTagEquals(String singularValue) {
            return this.definedTagEquals(Arrays.asList(singularValue));
        }

        public Builder freeformTagEquals(List<String> freeformTagEquals) {
            this.freeformTagEquals = freeformTagEquals;
            return this;
        }

        public Builder freeformTagEquals(String singularValue) {
            return this.freeformTagEquals(Arrays.asList(singularValue));
        }

        public Builder definedTagExists(List<String> definedTagExists) {
            this.definedTagExists = definedTagExists;
            return this;
        }

        public Builder definedTagExists(String singularValue) {
            return this.definedTagExists(Arrays.asList(singularValue));
        }

        public Builder freeformTagExists(List<String> freeformTagExists) {
            this.freeformTagExists = freeformTagExists;
            return this;
        }

        public Builder freeformTagExists(String singularValue) {
            return this.freeformTagExists(Arrays.asList(singularValue));
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder vmclusterName(List<String> vmclusterName) {
            this.vmclusterName = vmclusterName;
            return this;
        }

        public Builder vmclusterName(String singularValue) {
            return this.vmclusterName(Arrays.asList(singularValue));
        }

        public Builder highUtilizationThreshold(Integer highUtilizationThreshold) {
            this.highUtilizationThreshold = highUtilizationThreshold;
            return this;
        }

        public Builder lowUtilizationThreshold(Integer lowUtilizationThreshold) {
            this.lowUtilizationThreshold = lowUtilizationThreshold;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeDatabaseInsightResourceCapacityTrendRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceMetric(o.getResourceMetric());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.databaseType(o.getDatabaseType());
            this.databaseId(o.getDatabaseId());
            this.id(o.getId());
            this.exadataInsightId(o.getExadataInsightId());
            this.cdbName(o.getCdbName());
            this.utilizationLevel(o.getUtilizationLevel());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.tablespaceName(o.getTablespaceName());
            this.hostName(o.getHostName());
            this.isDatabaseInstanceLevelMetrics(o.getIsDatabaseInstanceLevelMetrics());
            this.opcRequestId(o.getOpcRequestId());
            this.definedTagEquals(o.getDefinedTagEquals());
            this.freeformTagEquals(o.getFreeformTagEquals());
            this.definedTagExists(o.getDefinedTagExists());
            this.freeformTagExists(o.getFreeformTagExists());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.vmclusterName(o.getVmclusterName());
            this.highUtilizationThreshold(o.getHighUtilizationThreshold());
            this.lowUtilizationThreshold(o.getLowUtilizationThreshold());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeDatabaseInsightResourceCapacityTrendRequest build() {
            SummarizeDatabaseInsightResourceCapacityTrendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeDatabaseInsightResourceCapacityTrendRequest buildWithoutInvocationCallback() {
            SummarizeDatabaseInsightResourceCapacityTrendRequest request = new SummarizeDatabaseInsightResourceCapacityTrendRequest();
            request.compartmentId = this.compartmentId;
            request.resourceMetric = this.resourceMetric;
            request.analysisTimeInterval = this.analysisTimeInterval;
            request.timeIntervalStart = this.timeIntervalStart;
            request.timeIntervalEnd = this.timeIntervalEnd;
            request.databaseType = this.databaseType;
            request.databaseId = this.databaseId;
            request.id = this.id;
            request.exadataInsightId = this.exadataInsightId;
            request.cdbName = this.cdbName;
            request.utilizationLevel = this.utilizationLevel;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.tablespaceName = this.tablespaceName;
            request.hostName = this.hostName;
            request.isDatabaseInstanceLevelMetrics = this.isDatabaseInstanceLevelMetrics;
            request.opcRequestId = this.opcRequestId;
            request.definedTagEquals = this.definedTagEquals;
            request.freeformTagEquals = this.freeformTagEquals;
            request.definedTagExists = this.definedTagExists;
            request.freeformTagExists = this.freeformTagExists;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.vmclusterName = this.vmclusterName;
            request.highUtilizationThreshold = this.highUtilizationThreshold;
            request.lowUtilizationThreshold = this.lowUtilizationThreshold;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        EndTimestamp("endTimestamp"),
        Capacity("capacity"),
        BaseCapacity("baseCapacity");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UtilizationLevel implements BmcEnum
    {
        HighUtilization("HIGH_UTILIZATION"),
        LowUtilization("LOW_UTILIZATION"),
        MediumHighUtilization("MEDIUM_HIGH_UTILIZATION"),
        MediumLowUtilization("MEDIUM_LOW_UTILIZATION");

        private final String value;
        private static Map<String, UtilizationLevel> map;

        private UtilizationLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UtilizationLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UtilizationLevel: " + key);
        }

        static {
            map = new HashMap<String, UtilizationLevel>();
            for (UtilizationLevel v : UtilizationLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseType implements BmcEnum
    {
        AdwS("ADW-S"),
        AtpS("ATP-S"),
        AdwD("ADW-D"),
        AtpD("ATP-D"),
        ExternalPdb("EXTERNAL-PDB"),
        ExternalNoncdb("EXTERNAL-NONCDB"),
        ComanagedVmCdb("COMANAGED-VM-CDB"),
        ComanagedVmPdb("COMANAGED-VM-PDB"),
        ComanagedVmNoncdb("COMANAGED-VM-NONCDB"),
        ComanagedBmCdb("COMANAGED-BM-CDB"),
        ComanagedBmPdb("COMANAGED-BM-PDB"),
        ComanagedBmNoncdb("COMANAGED-BM-NONCDB"),
        ComanagedExacsCdb("COMANAGED-EXACS-CDB"),
        ComanagedExacsPdb("COMANAGED-EXACS-PDB"),
        ComanagedExacsNoncdb("COMANAGED-EXACS-NONCDB");

        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseType: " + key);
        }

        static {
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

