/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeExadataMembersRequest
extends BmcRequest<Void> {
    private String exadataInsightId;
    private List<String> exadataType;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getExadataInsightId() {
        return this.exadataInsightId;
    }

    public List<String> getExadataType() {
        return this.exadataType;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().exadataInsightId(this.exadataInsightId).exadataType(this.exadataType).sortOrder(this.sortOrder).sortBy(this.sortBy).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",exadataInsightId=").append(String.valueOf(this.exadataInsightId));
        sb.append(",exadataType=").append(String.valueOf(this.exadataType));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeExadataMembersRequest)) {
            return false;
        }
        SummarizeExadataMembersRequest other = (SummarizeExadataMembersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.exadataInsightId, other.exadataInsightId) && Objects.equals(this.exadataType, other.exadataType) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exadataInsightId == null ? 43 : this.exadataInsightId.hashCode());
        result = result * 59 + (this.exadataType == null ? 43 : this.exadataType.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeExadataMembersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String exadataInsightId = null;
        private List<String> exadataType = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder exadataInsightId(String exadataInsightId) {
            this.exadataInsightId = exadataInsightId;
            return this;
        }

        public Builder exadataType(List<String> exadataType) {
            this.exadataType = exadataType;
            return this;
        }

        public Builder exadataType(String singularValue) {
            return this.exadataType(Arrays.asList(singularValue));
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeExadataMembersRequest o) {
            this.exadataInsightId(o.getExadataInsightId());
            this.exadataType(o.getExadataType());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeExadataMembersRequest build() {
            SummarizeExadataMembersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeExadataMembersRequest buildWithoutInvocationCallback() {
            SummarizeExadataMembersRequest request = new SummarizeExadataMembersRequest();
            request.exadataInsightId = this.exadataInsightId;
            request.exadataType = this.exadataType;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Name("name"),
        DisplayName("displayName"),
        EntityType("entityType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

