/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.ConfigurationItemMetadata;
import com.oracle.bmc.opsi.model.ConfigurationItemSummary;
import com.oracle.bmc.opsi.model.ConfigurationItemValueSourceConfigurationType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configItemType")
@JsonFilter(value="explicitlySetFilter")
public final class BasicConfigurationItemSummary
extends ConfigurationItemSummary {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="valueSourceConfig")
    private final ConfigurationItemValueSourceConfigurationType valueSourceConfig;
    @JsonProperty(value="defaultValue")
    private final String defaultValue;
    @JsonProperty(value="applicableContexts")
    private final List<String> applicableContexts;
    @JsonProperty(value="metadata")
    private final ConfigurationItemMetadata metadata;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BasicConfigurationItemSummary(String name, String value, ConfigurationItemValueSourceConfigurationType valueSourceConfig, String defaultValue, List<String> applicableContexts, ConfigurationItemMetadata metadata) {
        this.name = name;
        this.value = value;
        this.valueSourceConfig = valueSourceConfig;
        this.defaultValue = defaultValue;
        this.applicableContexts = applicableContexts;
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public ConfigurationItemValueSourceConfigurationType getValueSourceConfig() {
        return this.valueSourceConfig;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public List<String> getApplicableContexts() {
        return this.applicableContexts;
    }

    public ConfigurationItemMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicConfigurationItemSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", valueSourceConfig=").append(String.valueOf((Object)this.valueSourceConfig));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", applicableContexts=").append(String.valueOf(this.applicableContexts));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicConfigurationItemSummary)) {
            return false;
        }
        BasicConfigurationItemSummary other = (BasicConfigurationItemSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.valueSourceConfig, (Object)other.valueSourceConfig) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.applicableContexts, other.applicableContexts) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.valueSourceConfig == null ? 43 : this.valueSourceConfig.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.applicableContexts == null ? 43 : this.applicableContexts.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="valueSourceConfig")
        private ConfigurationItemValueSourceConfigurationType valueSourceConfig;
        @JsonProperty(value="defaultValue")
        private String defaultValue;
        @JsonProperty(value="applicableContexts")
        private List<String> applicableContexts;
        @JsonProperty(value="metadata")
        private ConfigurationItemMetadata metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder valueSourceConfig(ConfigurationItemValueSourceConfigurationType valueSourceConfig) {
            this.valueSourceConfig = valueSourceConfig;
            this.__explicitlySet__.add("valueSourceConfig");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder applicableContexts(List<String> applicableContexts) {
            this.applicableContexts = applicableContexts;
            this.__explicitlySet__.add("applicableContexts");
            return this;
        }

        public Builder metadata(ConfigurationItemMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public BasicConfigurationItemSummary build() {
            BasicConfigurationItemSummary model = new BasicConfigurationItemSummary(this.name, this.value, this.valueSourceConfig, this.defaultValue, this.applicableContexts, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BasicConfigurationItemSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("valueSourceConfig")) {
                this.valueSourceConfig(model.getValueSourceConfig());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("applicableContexts")) {
                this.applicableContexts(model.getApplicableContexts());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

