/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationSummary;
import com.oracle.bmc.opsi.model.ExadataDetails;
import com.oracle.bmc.opsi.model.HostInstanceMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entitySource")
@JsonFilter(value="explicitlySetFilter")
public final class EmManagedExternalDatabaseConfigurationSummary
extends DatabaseConfigurationSummary {
    @JsonProperty(value="enterpriseManagerIdentifier")
    private final String enterpriseManagerIdentifier;
    @JsonProperty(value="enterpriseManagerBridgeId")
    private final String enterpriseManagerBridgeId;
    @JsonProperty(value="instances")
    private final List<HostInstanceMap> instances;
    @JsonProperty(value="exadataDetails")
    private final ExadataDetails exadataDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public EmManagedExternalDatabaseConfigurationSummary(String databaseInsightId, String compartmentId, String databaseName, String databaseDisplayName, String databaseType, String databaseVersion, String cdbName, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, Integer processorCount, String enterpriseManagerIdentifier, String enterpriseManagerBridgeId, List<HostInstanceMap> instances, ExadataDetails exadataDetails) {
        super(databaseInsightId, compartmentId, databaseName, databaseDisplayName, databaseType, databaseVersion, cdbName, definedTags, freeformTags, processorCount);
        this.enterpriseManagerIdentifier = enterpriseManagerIdentifier;
        this.enterpriseManagerBridgeId = enterpriseManagerBridgeId;
        this.instances = instances;
        this.exadataDetails = exadataDetails;
    }

    public String getEnterpriseManagerIdentifier() {
        return this.enterpriseManagerIdentifier;
    }

    public String getEnterpriseManagerBridgeId() {
        return this.enterpriseManagerBridgeId;
    }

    public List<HostInstanceMap> getInstances() {
        return this.instances;
    }

    public ExadataDetails getExadataDetails() {
        return this.exadataDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EmManagedExternalDatabaseConfigurationSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", enterpriseManagerIdentifier=").append(String.valueOf(this.enterpriseManagerIdentifier));
        sb.append(", enterpriseManagerBridgeId=").append(String.valueOf(this.enterpriseManagerBridgeId));
        sb.append(", instances=").append(String.valueOf(this.instances));
        sb.append(", exadataDetails=").append(String.valueOf((Object)this.exadataDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmManagedExternalDatabaseConfigurationSummary)) {
            return false;
        }
        EmManagedExternalDatabaseConfigurationSummary other = (EmManagedExternalDatabaseConfigurationSummary)((Object)o);
        return Objects.equals(this.enterpriseManagerIdentifier, other.enterpriseManagerIdentifier) && Objects.equals(this.enterpriseManagerBridgeId, other.enterpriseManagerBridgeId) && Objects.equals(this.instances, other.instances) && Objects.equals((Object)this.exadataDetails, (Object)other.exadataDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.enterpriseManagerIdentifier == null ? 43 : this.enterpriseManagerIdentifier.hashCode());
        result = result * 59 + (this.enterpriseManagerBridgeId == null ? 43 : this.enterpriseManagerBridgeId.hashCode());
        result = result * 59 + (this.instances == null ? 43 : this.instances.hashCode());
        result = result * 59 + (this.exadataDetails == null ? 43 : this.exadataDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseInsightId")
        private String databaseInsightId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="databaseDisplayName")
        private String databaseDisplayName;
        @JsonProperty(value="databaseType")
        private String databaseType;
        @JsonProperty(value="databaseVersion")
        private String databaseVersion;
        @JsonProperty(value="cdbName")
        private String cdbName;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="processorCount")
        private Integer processorCount;
        @JsonProperty(value="enterpriseManagerIdentifier")
        private String enterpriseManagerIdentifier;
        @JsonProperty(value="enterpriseManagerBridgeId")
        private String enterpriseManagerBridgeId;
        @JsonProperty(value="instances")
        private List<HostInstanceMap> instances;
        @JsonProperty(value="exadataDetails")
        private ExadataDetails exadataDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseInsightId(String databaseInsightId) {
            this.databaseInsightId = databaseInsightId;
            this.__explicitlySet__.add("databaseInsightId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder databaseDisplayName(String databaseDisplayName) {
            this.databaseDisplayName = databaseDisplayName;
            this.__explicitlySet__.add("databaseDisplayName");
            return this;
        }

        public Builder databaseType(String databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            this.__explicitlySet__.add("databaseVersion");
            return this;
        }

        public Builder cdbName(String cdbName) {
            this.cdbName = cdbName;
            this.__explicitlySet__.add("cdbName");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder processorCount(Integer processorCount) {
            this.processorCount = processorCount;
            this.__explicitlySet__.add("processorCount");
            return this;
        }

        public Builder enterpriseManagerIdentifier(String enterpriseManagerIdentifier) {
            this.enterpriseManagerIdentifier = enterpriseManagerIdentifier;
            this.__explicitlySet__.add("enterpriseManagerIdentifier");
            return this;
        }

        public Builder enterpriseManagerBridgeId(String enterpriseManagerBridgeId) {
            this.enterpriseManagerBridgeId = enterpriseManagerBridgeId;
            this.__explicitlySet__.add("enterpriseManagerBridgeId");
            return this;
        }

        public Builder instances(List<HostInstanceMap> instances) {
            this.instances = instances;
            this.__explicitlySet__.add("instances");
            return this;
        }

        public Builder exadataDetails(ExadataDetails exadataDetails) {
            this.exadataDetails = exadataDetails;
            this.__explicitlySet__.add("exadataDetails");
            return this;
        }

        public EmManagedExternalDatabaseConfigurationSummary build() {
            EmManagedExternalDatabaseConfigurationSummary model = new EmManagedExternalDatabaseConfigurationSummary(this.databaseInsightId, this.compartmentId, this.databaseName, this.databaseDisplayName, this.databaseType, this.databaseVersion, this.cdbName, this.definedTags, this.freeformTags, this.processorCount, this.enterpriseManagerIdentifier, this.enterpriseManagerBridgeId, this.instances, this.exadataDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EmManagedExternalDatabaseConfigurationSummary model) {
            if (model.wasPropertyExplicitlySet("databaseInsightId")) {
                this.databaseInsightId(model.getDatabaseInsightId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("databaseDisplayName")) {
                this.databaseDisplayName(model.getDatabaseDisplayName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("databaseVersion")) {
                this.databaseVersion(model.getDatabaseVersion());
            }
            if (model.wasPropertyExplicitlySet("cdbName")) {
                this.cdbName(model.getCdbName());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("processorCount")) {
                this.processorCount(model.getProcessorCount());
            }
            if (model.wasPropertyExplicitlySet("enterpriseManagerIdentifier")) {
                this.enterpriseManagerIdentifier(model.getEnterpriseManagerIdentifier());
            }
            if (model.wasPropertyExplicitlySet("enterpriseManagerBridgeId")) {
                this.enterpriseManagerBridgeId(model.getEnterpriseManagerBridgeId());
            }
            if (model.wasPropertyExplicitlySet("instances")) {
                this.instances(model.getInstances());
            }
            if (model.wasPropertyExplicitlySet("exadataDetails")) {
                this.exadataDetails(model.getExadataDetails());
            }
            return this;
        }
    }
}

