/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostResourceAllocation
extends HostConfigurationMetricGroup {
    @JsonProperty(value="totalCpus")
    private final Integer totalCpus;
    @JsonProperty(value="totalMemoryInGB")
    private final Double totalMemoryInGB;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostResourceAllocation(Date timeCollected, Integer totalCpus, Double totalMemoryInGB) {
        super(timeCollected);
        this.totalCpus = totalCpus;
        this.totalMemoryInGB = totalMemoryInGB;
    }

    public Integer getTotalCpus() {
        return this.totalCpus;
    }

    public Double getTotalMemoryInGB() {
        return this.totalMemoryInGB;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostResourceAllocation(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", totalCpus=").append(String.valueOf(this.totalCpus));
        sb.append(", totalMemoryInGB=").append(String.valueOf(this.totalMemoryInGB));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostResourceAllocation)) {
            return false;
        }
        HostResourceAllocation other = (HostResourceAllocation)((Object)o);
        return Objects.equals(this.totalCpus, other.totalCpus) && Objects.equals(this.totalMemoryInGB, other.totalMemoryInGB) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.totalCpus == null ? 43 : this.totalCpus.hashCode());
        result = result * 59 + (this.totalMemoryInGB == null ? 43 : this.totalMemoryInGB.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="totalCpus")
        private Integer totalCpus;
        @JsonProperty(value="totalMemoryInGB")
        private Double totalMemoryInGB;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder totalCpus(Integer totalCpus) {
            this.totalCpus = totalCpus;
            this.__explicitlySet__.add("totalCpus");
            return this;
        }

        public Builder totalMemoryInGB(Double totalMemoryInGB) {
            this.totalMemoryInGB = totalMemoryInGB;
            this.__explicitlySet__.add("totalMemoryInGB");
            return this;
        }

        public HostResourceAllocation build() {
            HostResourceAllocation model = new HostResourceAllocation(this.timeCollected, this.totalCpus, this.totalMemoryInGB);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostResourceAllocation model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("totalCpus")) {
                this.totalCpus(model.getTotalCpus());
            }
            if (model.wasPropertyExplicitlySet("totalMemoryInGB")) {
                this.totalMemoryInGB(model.getTotalMemoryInGB());
            }
            return this;
        }
    }
}

