/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlInventory
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalSqls")
    private final Long totalSqls;
    @JsonProperty(value="totalDatabases")
    private final Integer totalDatabases;
    @JsonProperty(value="sqlsAnalyzed")
    private final Long sqlsAnalyzed;

    @Deprecated
    @ConstructorProperties(value={"totalSqls", "totalDatabases", "sqlsAnalyzed"})
    public SqlInventory(Long totalSqls, Integer totalDatabases, Long sqlsAnalyzed) {
        this.totalSqls = totalSqls;
        this.totalDatabases = totalDatabases;
        this.sqlsAnalyzed = sqlsAnalyzed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getTotalSqls() {
        return this.totalSqls;
    }

    public Integer getTotalDatabases() {
        return this.totalDatabases;
    }

    public Long getSqlsAnalyzed() {
        return this.sqlsAnalyzed;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlInventory(");
        sb.append("super=").append(super.toString());
        sb.append("totalSqls=").append(String.valueOf(this.totalSqls));
        sb.append(", totalDatabases=").append(String.valueOf(this.totalDatabases));
        sb.append(", sqlsAnalyzed=").append(String.valueOf(this.sqlsAnalyzed));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlInventory)) {
            return false;
        }
        SqlInventory other = (SqlInventory)((Object)o);
        return Objects.equals(this.totalSqls, other.totalSqls) && Objects.equals(this.totalDatabases, other.totalDatabases) && Objects.equals(this.sqlsAnalyzed, other.sqlsAnalyzed) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalSqls == null ? 43 : this.totalSqls.hashCode());
        result = result * 59 + (this.totalDatabases == null ? 43 : this.totalDatabases.hashCode());
        result = result * 59 + (this.sqlsAnalyzed == null ? 43 : this.sqlsAnalyzed.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalSqls")
        private Long totalSqls;
        @JsonProperty(value="totalDatabases")
        private Integer totalDatabases;
        @JsonProperty(value="sqlsAnalyzed")
        private Long sqlsAnalyzed;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalSqls(Long totalSqls) {
            this.totalSqls = totalSqls;
            this.__explicitlySet__.add("totalSqls");
            return this;
        }

        public Builder totalDatabases(Integer totalDatabases) {
            this.totalDatabases = totalDatabases;
            this.__explicitlySet__.add("totalDatabases");
            return this;
        }

        public Builder sqlsAnalyzed(Long sqlsAnalyzed) {
            this.sqlsAnalyzed = sqlsAnalyzed;
            this.__explicitlySet__.add("sqlsAnalyzed");
            return this;
        }

        public SqlInventory build() {
            SqlInventory model = new SqlInventory(this.totalSqls, this.totalDatabases, this.sqlsAnalyzed);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlInventory model) {
            if (model.wasPropertyExplicitlySet("totalSqls")) {
                this.totalSqls(model.getTotalSqls());
            }
            if (model.wasPropertyExplicitlySet("totalDatabases")) {
                this.totalDatabases(model.getTotalDatabases());
            }
            if (model.wasPropertyExplicitlySet("sqlsAnalyzed")) {
                this.sqlsAnalyzed(model.getSqlsAnalyzed());
            }
            return this;
        }
    }
}

