/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.RelatedObjectTypeDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class SqlTypeDetails
extends RelatedObjectTypeDetails {
    @JsonProperty(value="sqlId")
    private final String sqlId;
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="isSqlTextTruncated")
    private final Boolean isSqlTextTruncated;
    @JsonProperty(value="sqlCommand")
    private final String sqlCommand;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SqlTypeDetails(String sqlId, String sqlText, Boolean isSqlTextTruncated, String sqlCommand) {
        this.sqlId = sqlId;
        this.sqlText = sqlText;
        this.isSqlTextTruncated = isSqlTextTruncated;
        this.sqlCommand = sqlCommand;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public Boolean getIsSqlTextTruncated() {
        return this.isSqlTextTruncated;
    }

    public String getSqlCommand() {
        return this.sqlCommand;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlTypeDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sqlId=").append(String.valueOf(this.sqlId));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", isSqlTextTruncated=").append(String.valueOf(this.isSqlTextTruncated));
        sb.append(", sqlCommand=").append(String.valueOf(this.sqlCommand));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlTypeDetails)) {
            return false;
        }
        SqlTypeDetails other = (SqlTypeDetails)((Object)o);
        return Objects.equals(this.sqlId, other.sqlId) && Objects.equals(this.sqlText, other.sqlText) && Objects.equals(this.isSqlTextTruncated, other.isSqlTextTruncated) && Objects.equals(this.sqlCommand, other.sqlCommand) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sqlId == null ? 43 : this.sqlId.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.isSqlTextTruncated == null ? 43 : this.isSqlTextTruncated.hashCode());
        result = result * 59 + (this.sqlCommand == null ? 43 : this.sqlCommand.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sqlId")
        private String sqlId;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="isSqlTextTruncated")
        private Boolean isSqlTextTruncated;
        @JsonProperty(value="sqlCommand")
        private String sqlCommand;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sqlId(String sqlId) {
            this.sqlId = sqlId;
            this.__explicitlySet__.add("sqlId");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder isSqlTextTruncated(Boolean isSqlTextTruncated) {
            this.isSqlTextTruncated = isSqlTextTruncated;
            this.__explicitlySet__.add("isSqlTextTruncated");
            return this;
        }

        public Builder sqlCommand(String sqlCommand) {
            this.sqlCommand = sqlCommand;
            this.__explicitlySet__.add("sqlCommand");
            return this;
        }

        public SqlTypeDetails build() {
            SqlTypeDetails model = new SqlTypeDetails(this.sqlId, this.sqlText, this.isSqlTextTruncated, this.sqlCommand);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlTypeDetails model) {
            if (model.wasPropertyExplicitlySet("sqlId")) {
                this.sqlId(model.getSqlId());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("isSqlTextTruncated")) {
                this.isSqlTextTruncated(model.getIsSqlTextTruncated());
            }
            if (model.wasPropertyExplicitlySet("sqlCommand")) {
                this.sqlCommand(model.getSqlCommand());
            }
            return this;
        }
    }
}

