/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummarizeDatabaseInsightResourceUsageAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeIntervalStart")
    private final Date timeIntervalStart;
    @JsonProperty(value="timeIntervalEnd")
    private final Date timeIntervalEnd;
    @JsonProperty(value="resourceMetric")
    private final ResourceMetric resourceMetric;
    @JsonProperty(value="usageUnit")
    private final UsageUnit usageUnit;
    @JsonProperty(value="usage")
    private final Double usage;
    @JsonProperty(value="capacity")
    private final Double capacity;
    @JsonProperty(value="usageChangePercent")
    private final Double usageChangePercent;
    @JsonProperty(value="totalHostCapacity")
    private final Double totalHostCapacity;

    @Deprecated
    @ConstructorProperties(value={"timeIntervalStart", "timeIntervalEnd", "resourceMetric", "usageUnit", "usage", "capacity", "usageChangePercent", "totalHostCapacity"})
    public SummarizeDatabaseInsightResourceUsageAggregation(Date timeIntervalStart, Date timeIntervalEnd, ResourceMetric resourceMetric, UsageUnit usageUnit, Double usage, Double capacity, Double usageChangePercent, Double totalHostCapacity) {
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.resourceMetric = resourceMetric;
        this.usageUnit = usageUnit;
        this.usage = usage;
        this.capacity = capacity;
        this.usageChangePercent = usageChangePercent;
        this.totalHostCapacity = totalHostCapacity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public ResourceMetric getResourceMetric() {
        return this.resourceMetric;
    }

    public UsageUnit getUsageUnit() {
        return this.usageUnit;
    }

    public Double getUsage() {
        return this.usage;
    }

    public Double getCapacity() {
        return this.capacity;
    }

    public Double getUsageChangePercent() {
        return this.usageChangePercent;
    }

    public Double getTotalHostCapacity() {
        return this.totalHostCapacity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummarizeDatabaseInsightResourceUsageAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(", timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(", resourceMetric=").append(String.valueOf((Object)this.resourceMetric));
        sb.append(", usageUnit=").append(String.valueOf((Object)this.usageUnit));
        sb.append(", usage=").append(String.valueOf(this.usage));
        sb.append(", capacity=").append(String.valueOf(this.capacity));
        sb.append(", usageChangePercent=").append(String.valueOf(this.usageChangePercent));
        sb.append(", totalHostCapacity=").append(String.valueOf(this.totalHostCapacity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeDatabaseInsightResourceUsageAggregation)) {
            return false;
        }
        SummarizeDatabaseInsightResourceUsageAggregation other = (SummarizeDatabaseInsightResourceUsageAggregation)((Object)o);
        return Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals((Object)this.resourceMetric, (Object)other.resourceMetric) && Objects.equals((Object)this.usageUnit, (Object)other.usageUnit) && Objects.equals(this.usage, other.usage) && Objects.equals(this.capacity, other.capacity) && Objects.equals(this.usageChangePercent, other.usageChangePercent) && Objects.equals(this.totalHostCapacity, other.totalHostCapacity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.resourceMetric == null ? 43 : this.resourceMetric.hashCode());
        result = result * 59 + (this.usageUnit == null ? 43 : this.usageUnit.hashCode());
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + (this.capacity == null ? 43 : this.capacity.hashCode());
        result = result * 59 + (this.usageChangePercent == null ? 43 : this.usageChangePercent.hashCode());
        result = result * 59 + (this.totalHostCapacity == null ? 43 : this.totalHostCapacity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UsageUnit implements BmcEnum
    {
        Cores("CORES"),
        Gb("GB"),
        Mbps("MBPS"),
        Iops("IOPS"),
        Percent("PERCENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UsageUnit> map;

        private UsageUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UsageUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UsageUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UsageUnit.class);
            map = new HashMap<String, UsageUnit>();
            for (UsageUnit v : UsageUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResourceMetric implements BmcEnum
    {
        Cpu("CPU"),
        Storage("STORAGE"),
        Io("IO"),
        Memory("MEMORY"),
        MemoryPga("MEMORY_PGA"),
        MemorySga("MEMORY_SGA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceMetric> map;

        private ResourceMetric(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceMetric create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceMetric', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceMetric.class);
            map = new HashMap<String, ResourceMetric>();
            for (ResourceMetric v : ResourceMetric.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeIntervalStart")
        private Date timeIntervalStart;
        @JsonProperty(value="timeIntervalEnd")
        private Date timeIntervalEnd;
        @JsonProperty(value="resourceMetric")
        private ResourceMetric resourceMetric;
        @JsonProperty(value="usageUnit")
        private UsageUnit usageUnit;
        @JsonProperty(value="usage")
        private Double usage;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="usageChangePercent")
        private Double usageChangePercent;
        @JsonProperty(value="totalHostCapacity")
        private Double totalHostCapacity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            this.__explicitlySet__.add("timeIntervalStart");
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            this.__explicitlySet__.add("timeIntervalEnd");
            return this;
        }

        public Builder resourceMetric(ResourceMetric resourceMetric) {
            this.resourceMetric = resourceMetric;
            this.__explicitlySet__.add("resourceMetric");
            return this;
        }

        public Builder usageUnit(UsageUnit usageUnit) {
            this.usageUnit = usageUnit;
            this.__explicitlySet__.add("usageUnit");
            return this;
        }

        public Builder usage(Double usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder usageChangePercent(Double usageChangePercent) {
            this.usageChangePercent = usageChangePercent;
            this.__explicitlySet__.add("usageChangePercent");
            return this;
        }

        public Builder totalHostCapacity(Double totalHostCapacity) {
            this.totalHostCapacity = totalHostCapacity;
            this.__explicitlySet__.add("totalHostCapacity");
            return this;
        }

        public SummarizeDatabaseInsightResourceUsageAggregation build() {
            SummarizeDatabaseInsightResourceUsageAggregation model = new SummarizeDatabaseInsightResourceUsageAggregation(this.timeIntervalStart, this.timeIntervalEnd, this.resourceMetric, this.usageUnit, this.usage, this.capacity, this.usageChangePercent, this.totalHostCapacity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummarizeDatabaseInsightResourceUsageAggregation model) {
            if (model.wasPropertyExplicitlySet("timeIntervalStart")) {
                this.timeIntervalStart(model.getTimeIntervalStart());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalEnd")) {
                this.timeIntervalEnd(model.getTimeIntervalEnd());
            }
            if (model.wasPropertyExplicitlySet("resourceMetric")) {
                this.resourceMetric(model.getResourceMetric());
            }
            if (model.wasPropertyExplicitlySet("usageUnit")) {
                this.usageUnit(model.getUsageUnit());
            }
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("usageChangePercent")) {
                this.usageChangePercent(model.getUsageChangePercent());
            }
            if (model.wasPropertyExplicitlySet("totalHostCapacity")) {
                this.totalHostCapacity(model.getTotalHostCapacity());
            }
            return this;
        }
    }
}

