/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.DataObjectType;
import com.oracle.bmc.opsi.model.WarehouseDataObjectDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WarehouseDataObjectSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dataObjectType")
    private final DataObjectType dataObjectType;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="owner")
    private final String owner;
    @JsonProperty(value="details")
    private final WarehouseDataObjectDetails details;

    @Deprecated
    @ConstructorProperties(value={"dataObjectType", "name", "owner", "details"})
    public WarehouseDataObjectSummary(DataObjectType dataObjectType, String name, String owner, WarehouseDataObjectDetails details) {
        this.dataObjectType = dataObjectType;
        this.name = name;
        this.owner = owner;
        this.details = details;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DataObjectType getDataObjectType() {
        return this.dataObjectType;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public WarehouseDataObjectDetails getDetails() {
        return this.details;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WarehouseDataObjectSummary(");
        sb.append("super=").append(super.toString());
        sb.append("dataObjectType=").append(String.valueOf((Object)this.dataObjectType));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", owner=").append(String.valueOf(this.owner));
        sb.append(", details=").append(String.valueOf((Object)this.details));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WarehouseDataObjectSummary)) {
            return false;
        }
        WarehouseDataObjectSummary other = (WarehouseDataObjectSummary)((Object)o);
        return Objects.equals((Object)this.dataObjectType, (Object)other.dataObjectType) && Objects.equals(this.name, other.name) && Objects.equals(this.owner, other.owner) && Objects.equals((Object)this.details, (Object)other.details) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dataObjectType == null ? 43 : this.dataObjectType.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.details == null ? 43 : this.details.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dataObjectType")
        private DataObjectType dataObjectType;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="details")
        private WarehouseDataObjectDetails details;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dataObjectType(DataObjectType dataObjectType) {
            this.dataObjectType = dataObjectType;
            this.__explicitlySet__.add("dataObjectType");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder details(WarehouseDataObjectDetails details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public WarehouseDataObjectSummary build() {
            WarehouseDataObjectSummary model = new WarehouseDataObjectSummary(this.dataObjectType, this.name, this.owner, this.details);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WarehouseDataObjectSummary model) {
            if (model.wasPropertyExplicitlySet("dataObjectType")) {
                this.dataObjectType(model.getDataObjectType());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("details")) {
                this.details(model.getDetails());
            }
            return this;
        }
    }
}

