/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class HeadAwrHubObjectRequest
extends BmcRequest<Void> {
    private String awrHubSourceId;
    private String objectName;
    private String opcRequestId;

    public String getAwrHubSourceId() {
        return this.awrHubSourceId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().awrHubSourceId(this.awrHubSourceId).objectName(this.objectName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",awrHubSourceId=").append(String.valueOf(this.awrHubSourceId));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeadAwrHubObjectRequest)) {
            return false;
        }
        HeadAwrHubObjectRequest other = (HeadAwrHubObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.awrHubSourceId, other.awrHubSourceId) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.awrHubSourceId == null ? 43 : this.awrHubSourceId.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<HeadAwrHubObjectRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String awrHubSourceId = null;
        private String objectName = null;
        private String opcRequestId = null;

        public Builder awrHubSourceId(String awrHubSourceId) {
            this.awrHubSourceId = awrHubSourceId;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(HeadAwrHubObjectRequest o) {
            this.awrHubSourceId(o.getAwrHubSourceId());
            this.objectName(o.getObjectName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public HeadAwrHubObjectRequest build() {
            HeadAwrHubObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public HeadAwrHubObjectRequest buildWithoutInvocationCallback() {
            HeadAwrHubObjectRequest request = new HeadAwrHubObjectRequest();
            request.awrHubSourceId = this.awrHubSourceId;
            request.objectName = this.objectName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

