/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.LifecycleState;
import com.oracle.bmc.opsi.model.ResourceStatus;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListHostInsightsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<String> id;
    private List<ResourceStatus> status;
    private List<LifecycleState> lifecycleState;
    private List<String> hostType;
    private List<PlatformType> platformType;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String enterpriseManagerBridgeId;
    private String exadataInsightId;
    private Boolean compartmentIdInSubtree;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getId() {
        return this.id;
    }

    public List<ResourceStatus> getStatus() {
        return this.status;
    }

    public List<LifecycleState> getLifecycleState() {
        return this.lifecycleState;
    }

    public List<String> getHostType() {
        return this.hostType;
    }

    public List<PlatformType> getPlatformType() {
        return this.platformType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getEnterpriseManagerBridgeId() {
        return this.enterpriseManagerBridgeId;
    }

    public String getExadataInsightId() {
        return this.exadataInsightId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).id(this.id).status(this.status).lifecycleState(this.lifecycleState).hostType(this.hostType).platformType(this.platformType).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).enterpriseManagerBridgeId(this.enterpriseManagerBridgeId).exadataInsightId(this.exadataInsightId).compartmentIdInSubtree(this.compartmentIdInSubtree).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(",hostType=").append(String.valueOf(this.hostType));
        sb.append(",platformType=").append(String.valueOf(this.platformType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",enterpriseManagerBridgeId=").append(String.valueOf(this.enterpriseManagerBridgeId));
        sb.append(",exadataInsightId=").append(String.valueOf(this.exadataInsightId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListHostInsightsRequest)) {
            return false;
        }
        ListHostInsightsRequest other = (ListHostInsightsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.lifecycleState, other.lifecycleState) && Objects.equals(this.hostType, other.hostType) && Objects.equals(this.platformType, other.platformType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.enterpriseManagerBridgeId, other.enterpriseManagerBridgeId) && Objects.equals(this.exadataInsightId, other.exadataInsightId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.hostType == null ? 43 : this.hostType.hashCode());
        result = result * 59 + (this.platformType == null ? 43 : this.platformType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.enterpriseManagerBridgeId == null ? 43 : this.enterpriseManagerBridgeId.hashCode());
        result = result * 59 + (this.exadataInsightId == null ? 43 : this.exadataInsightId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListHostInsightsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<String> id = null;
        private List<ResourceStatus> status = null;
        private List<LifecycleState> lifecycleState = null;
        private List<String> hostType = null;
        private List<PlatformType> platformType = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String enterpriseManagerBridgeId = null;
        private String exadataInsightId = null;
        private Boolean compartmentIdInSubtree = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder id(List<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String singularValue) {
            return this.id(Arrays.asList(singularValue));
        }

        public Builder status(List<ResourceStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ResourceStatus singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder lifecycleState(List<LifecycleState> lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleState(LifecycleState singularValue) {
            return this.lifecycleState(Arrays.asList(singularValue));
        }

        public Builder hostType(List<String> hostType) {
            this.hostType = hostType;
            return this;
        }

        public Builder hostType(String singularValue) {
            return this.hostType(Arrays.asList(singularValue));
        }

        public Builder platformType(List<PlatformType> platformType) {
            this.platformType = platformType;
            return this;
        }

        public Builder platformType(PlatformType singularValue) {
            return this.platformType(Arrays.asList(singularValue));
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder enterpriseManagerBridgeId(String enterpriseManagerBridgeId) {
            this.enterpriseManagerBridgeId = enterpriseManagerBridgeId;
            return this;
        }

        public Builder exadataInsightId(String exadataInsightId) {
            this.exadataInsightId = exadataInsightId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListHostInsightsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.id(o.getId());
            this.status(o.getStatus());
            this.lifecycleState(o.getLifecycleState());
            this.hostType(o.getHostType());
            this.platformType(o.getPlatformType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.enterpriseManagerBridgeId(o.getEnterpriseManagerBridgeId());
            this.exadataInsightId(o.getExadataInsightId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListHostInsightsRequest build() {
            ListHostInsightsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListHostInsightsRequest buildWithoutInvocationCallback() {
            ListHostInsightsRequest request = new ListHostInsightsRequest();
            request.compartmentId = this.compartmentId;
            request.id = this.id;
            request.status = this.status;
            request.lifecycleState = this.lifecycleState;
            request.hostType = this.hostType;
            request.platformType = this.platformType;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.enterpriseManagerBridgeId = this.enterpriseManagerBridgeId;
            request.exadataInsightId = this.exadataInsightId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        HostName("hostName"),
        HostType("hostType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PlatformType implements BmcEnum
    {
        Linux("LINUX"),
        Solaris("SOLARIS"),
        Sunos("SUNOS"),
        Zlinux("ZLINUX"),
        Windows("WINDOWS"),
        Aix("AIX"),
        HpUx("HP_UX");

        private final String value;
        private static Map<String, PlatformType> map;

        private PlatformType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PlatformType: " + key);
        }

        static {
            map = new HashMap<String, PlatformType>();
            for (PlatformType v : PlatformType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

