/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SummarizeAwrDatabaseTopWaitEventsRequest
extends BmcRequest<Void> {
    private String awrHubId;
    private String awrSourceDatabaseIdentifier;
    private String instanceNumber;
    private Integer beginSnapshotIdentifierGreaterThanOrEqualTo;
    private Integer endSnapshotIdentifierLessThanOrEqualTo;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private SessionType sessionType;
    private Integer topN;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getAwrHubId() {
        return this.awrHubId;
    }

    public String getAwrSourceDatabaseIdentifier() {
        return this.awrSourceDatabaseIdentifier;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public Integer getBeginSnapshotIdentifierGreaterThanOrEqualTo() {
        return this.beginSnapshotIdentifierGreaterThanOrEqualTo;
    }

    public Integer getEndSnapshotIdentifierLessThanOrEqualTo() {
        return this.endSnapshotIdentifierLessThanOrEqualTo;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public Integer getTopN() {
        return this.topN;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().awrHubId(this.awrHubId).awrSourceDatabaseIdentifier(this.awrSourceDatabaseIdentifier).instanceNumber(this.instanceNumber).beginSnapshotIdentifierGreaterThanOrEqualTo(this.beginSnapshotIdentifierGreaterThanOrEqualTo).endSnapshotIdentifierLessThanOrEqualTo(this.endSnapshotIdentifierLessThanOrEqualTo).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).sessionType(this.sessionType).topN(this.topN).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",awrHubId=").append(String.valueOf(this.awrHubId));
        sb.append(",awrSourceDatabaseIdentifier=").append(String.valueOf(this.awrSourceDatabaseIdentifier));
        sb.append(",instanceNumber=").append(String.valueOf(this.instanceNumber));
        sb.append(",beginSnapshotIdentifierGreaterThanOrEqualTo=").append(String.valueOf(this.beginSnapshotIdentifierGreaterThanOrEqualTo));
        sb.append(",endSnapshotIdentifierLessThanOrEqualTo=").append(String.valueOf(this.endSnapshotIdentifierLessThanOrEqualTo));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",sessionType=").append(String.valueOf((Object)this.sessionType));
        sb.append(",topN=").append(String.valueOf(this.topN));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeAwrDatabaseTopWaitEventsRequest)) {
            return false;
        }
        SummarizeAwrDatabaseTopWaitEventsRequest other = (SummarizeAwrDatabaseTopWaitEventsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.awrHubId, other.awrHubId) && Objects.equals(this.awrSourceDatabaseIdentifier, other.awrSourceDatabaseIdentifier) && Objects.equals(this.instanceNumber, other.instanceNumber) && Objects.equals(this.beginSnapshotIdentifierGreaterThanOrEqualTo, other.beginSnapshotIdentifierGreaterThanOrEqualTo) && Objects.equals(this.endSnapshotIdentifierLessThanOrEqualTo, other.endSnapshotIdentifierLessThanOrEqualTo) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals((Object)this.sessionType, (Object)other.sessionType) && Objects.equals(this.topN, other.topN) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.awrHubId == null ? 43 : this.awrHubId.hashCode());
        result = result * 59 + (this.awrSourceDatabaseIdentifier == null ? 43 : this.awrSourceDatabaseIdentifier.hashCode());
        result = result * 59 + (this.instanceNumber == null ? 43 : this.instanceNumber.hashCode());
        result = result * 59 + (this.beginSnapshotIdentifierGreaterThanOrEqualTo == null ? 43 : this.beginSnapshotIdentifierGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.endSnapshotIdentifierLessThanOrEqualTo == null ? 43 : this.endSnapshotIdentifierLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.sessionType == null ? 43 : this.sessionType.hashCode());
        result = result * 59 + (this.topN == null ? 43 : this.topN.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeAwrDatabaseTopWaitEventsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String awrHubId = null;
        private String awrSourceDatabaseIdentifier = null;
        private String instanceNumber = null;
        private Integer beginSnapshotIdentifierGreaterThanOrEqualTo = null;
        private Integer endSnapshotIdentifierLessThanOrEqualTo = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private SessionType sessionType = null;
        private Integer topN = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder awrHubId(String awrHubId) {
            this.awrHubId = awrHubId;
            return this;
        }

        public Builder awrSourceDatabaseIdentifier(String awrSourceDatabaseIdentifier) {
            this.awrSourceDatabaseIdentifier = awrSourceDatabaseIdentifier;
            return this;
        }

        public Builder instanceNumber(String instanceNumber) {
            this.instanceNumber = instanceNumber;
            return this;
        }

        public Builder beginSnapshotIdentifierGreaterThanOrEqualTo(Integer beginSnapshotIdentifierGreaterThanOrEqualTo) {
            this.beginSnapshotIdentifierGreaterThanOrEqualTo = beginSnapshotIdentifierGreaterThanOrEqualTo;
            return this;
        }

        public Builder endSnapshotIdentifierLessThanOrEqualTo(Integer endSnapshotIdentifierLessThanOrEqualTo) {
            this.endSnapshotIdentifierLessThanOrEqualTo = endSnapshotIdentifierLessThanOrEqualTo;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder sessionType(SessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public Builder topN(Integer topN) {
            this.topN = topN;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeAwrDatabaseTopWaitEventsRequest o) {
            this.awrHubId(o.getAwrHubId());
            this.awrSourceDatabaseIdentifier(o.getAwrSourceDatabaseIdentifier());
            this.instanceNumber(o.getInstanceNumber());
            this.beginSnapshotIdentifierGreaterThanOrEqualTo(o.getBeginSnapshotIdentifierGreaterThanOrEqualTo());
            this.endSnapshotIdentifierLessThanOrEqualTo(o.getEndSnapshotIdentifierLessThanOrEqualTo());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.sessionType(o.getSessionType());
            this.topN(o.getTopN());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeAwrDatabaseTopWaitEventsRequest build() {
            SummarizeAwrDatabaseTopWaitEventsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeAwrDatabaseTopWaitEventsRequest buildWithoutInvocationCallback() {
            SummarizeAwrDatabaseTopWaitEventsRequest request = new SummarizeAwrDatabaseTopWaitEventsRequest();
            request.awrHubId = this.awrHubId;
            request.awrSourceDatabaseIdentifier = this.awrSourceDatabaseIdentifier;
            request.instanceNumber = this.instanceNumber;
            request.beginSnapshotIdentifierGreaterThanOrEqualTo = this.beginSnapshotIdentifierGreaterThanOrEqualTo;
            request.endSnapshotIdentifierLessThanOrEqualTo = this.endSnapshotIdentifierLessThanOrEqualTo;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.sessionType = this.sessionType;
            request.topN = this.topN;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        WaitsPersec("WAITS_PERSEC"),
        AvgWaitTimePersec("AVG_WAIT_TIME_PERSEC");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SessionType implements BmcEnum
    {
        Foreground("FOREGROUND"),
        Background("BACKGROUND"),
        All("ALL");

        private final String value;
        private static Map<String, SessionType> map;

        private SessionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SessionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SessionType: " + key);
        }

        static {
            map = new HashMap<String, SessionType>();
            for (SessionType v : SessionType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

