/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.OpsiConfigurationType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeConfigurationItemsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private OpsiConfigurationType opsiConfigType;
    private Integer limit;
    private String page;
    private List<String> configItemsApplicableContext;
    private List<ConfigItemField> configItemField;
    private String name;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public OpsiConfigurationType getOpsiConfigType() {
        return this.opsiConfigType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<String> getConfigItemsApplicableContext() {
        return this.configItemsApplicableContext;
    }

    public List<ConfigItemField> getConfigItemField() {
        return this.configItemField;
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opsiConfigType(this.opsiConfigType).limit(this.limit).page(this.page).configItemsApplicableContext(this.configItemsApplicableContext).configItemField(this.configItemField).name(this.name).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opsiConfigType=").append(String.valueOf((Object)this.opsiConfigType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",configItemsApplicableContext=").append(String.valueOf(this.configItemsApplicableContext));
        sb.append(",configItemField=").append(String.valueOf(this.configItemField));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeConfigurationItemsRequest)) {
            return false;
        }
        SummarizeConfigurationItemsRequest other = (SummarizeConfigurationItemsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.opsiConfigType, (Object)other.opsiConfigType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.configItemsApplicableContext, other.configItemsApplicableContext) && Objects.equals(this.configItemField, other.configItemField) && Objects.equals(this.name, other.name) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opsiConfigType == null ? 43 : this.opsiConfigType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.configItemsApplicableContext == null ? 43 : this.configItemsApplicableContext.hashCode());
        result = result * 59 + (this.configItemField == null ? 43 : this.configItemField.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeConfigurationItemsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private OpsiConfigurationType opsiConfigType = null;
        private Integer limit = null;
        private String page = null;
        private List<String> configItemsApplicableContext = null;
        private List<ConfigItemField> configItemField = null;
        private String name = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opsiConfigType(OpsiConfigurationType opsiConfigType) {
            this.opsiConfigType = opsiConfigType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder configItemsApplicableContext(List<String> configItemsApplicableContext) {
            this.configItemsApplicableContext = configItemsApplicableContext;
            return this;
        }

        public Builder configItemsApplicableContext(String singularValue) {
            return this.configItemsApplicableContext(Arrays.asList(singularValue));
        }

        public Builder configItemField(List<ConfigItemField> configItemField) {
            this.configItemField = configItemField;
            return this;
        }

        public Builder configItemField(ConfigItemField singularValue) {
            return this.configItemField(Arrays.asList(singularValue));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeConfigurationItemsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opsiConfigType(o.getOpsiConfigType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.configItemsApplicableContext(o.getConfigItemsApplicableContext());
            this.configItemField(o.getConfigItemField());
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeConfigurationItemsRequest build() {
            SummarizeConfigurationItemsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeConfigurationItemsRequest buildWithoutInvocationCallback() {
            SummarizeConfigurationItemsRequest request = new SummarizeConfigurationItemsRequest();
            request.compartmentId = this.compartmentId;
            request.opsiConfigType = this.opsiConfigType;
            request.limit = this.limit;
            request.page = this.page;
            request.configItemsApplicableContext = this.configItemsApplicableContext;
            request.configItemField = this.configItemField;
            request.name = this.name;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum ConfigItemField implements BmcEnum
    {
        Name("name"),
        Value("value"),
        DefaultValue("defaultValue"),
        ValueSourceConfig("valueSourceConfig"),
        Metadata("metadata"),
        ApplicableContexts("applicableContexts");

        private final String value;
        private static Map<String, ConfigItemField> map;

        private ConfigItemField(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfigItemField create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ConfigItemField: " + key);
        }

        static {
            map = new HashMap<String, ConfigItemField>();
            for (ConfigItemField v : ConfigItemField.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

