/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.responses;

import com.oracle.bmc.opsi.model.OpsiConfiguration;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateOpsiConfigurationResponse
extends BmcResponse {
    private String opcWorkRequestId;
    private String opcRequestId;
    private String etag;
    private OpsiConfiguration opsiConfiguration;

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public OpsiConfiguration getOpsiConfiguration() {
        return this.opsiConfiguration;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcWorkRequestId", "opcRequestId", "etag", "opsiConfiguration"})
    private CreateOpsiConfigurationResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcWorkRequestId, String opcRequestId, String etag, OpsiConfiguration opsiConfiguration) {
        super(__httpStatusCode__, headers);
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.opsiConfiguration = opsiConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opsiConfiguration=").append(String.valueOf((Object)this.opsiConfiguration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOpsiConfigurationResponse)) {
            return false;
        }
        CreateOpsiConfigurationResponse other = (CreateOpsiConfigurationResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.opsiConfiguration, (Object)other.opsiConfiguration);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opsiConfiguration == null ? 43 : this.opsiConfiguration.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateOpsiConfigurationResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcWorkRequestId;
        private String opcRequestId;
        private String etag;
        private OpsiConfiguration opsiConfiguration;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opsiConfiguration(OpsiConfiguration opsiConfiguration) {
            this.opsiConfiguration = opsiConfiguration;
            return this;
        }

        public Builder copy(CreateOpsiConfigurationResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.opsiConfiguration(o.getOpsiConfiguration());
            return this;
        }

        public CreateOpsiConfigurationResponse build() {
            return new CreateOpsiConfigurationResponse(this.__httpStatusCode__, this.headers, this.opcWorkRequestId, this.opcRequestId, this.etag, this.opsiConfiguration);
        }
    }
}

