/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.ConfigurationItemAllowedValueDetails;
import com.oracle.bmc.opsi.model.ConfigurationItemMetadata;
import com.oracle.bmc.opsi.model.ConfigurationItemUnitDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configItemType")
@JsonFilter(value="explicitlySetFilter")
public final class BasicConfigurationItemMetadata
extends ConfigurationItemMetadata {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="unitDetails")
    private final ConfigurationItemUnitDetails unitDetails;
    @JsonProperty(value="valueInputDetails")
    private final ConfigurationItemAllowedValueDetails valueInputDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BasicConfigurationItemMetadata(String displayName, String description, String dataType, ConfigurationItemUnitDetails unitDetails, ConfigurationItemAllowedValueDetails valueInputDetails) {
        this.displayName = displayName;
        this.description = description;
        this.dataType = dataType;
        this.unitDetails = unitDetails;
        this.valueInputDetails = valueInputDetails;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public ConfigurationItemUnitDetails getUnitDetails() {
        return this.unitDetails;
    }

    public ConfigurationItemAllowedValueDetails getValueInputDetails() {
        return this.valueInputDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicConfigurationItemMetadata(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", unitDetails=").append(String.valueOf((Object)this.unitDetails));
        sb.append(", valueInputDetails=").append(String.valueOf((Object)this.valueInputDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicConfigurationItemMetadata)) {
            return false;
        }
        BasicConfigurationItemMetadata other = (BasicConfigurationItemMetadata)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.dataType, other.dataType) && Objects.equals((Object)this.unitDetails, (Object)other.unitDetails) && Objects.equals((Object)this.valueInputDetails, (Object)other.valueInputDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.unitDetails == null ? 43 : this.unitDetails.hashCode());
        result = result * 59 + (this.valueInputDetails == null ? 43 : this.valueInputDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="unitDetails")
        private ConfigurationItemUnitDetails unitDetails;
        @JsonProperty(value="valueInputDetails")
        private ConfigurationItemAllowedValueDetails valueInputDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder unitDetails(ConfigurationItemUnitDetails unitDetails) {
            this.unitDetails = unitDetails;
            this.__explicitlySet__.add("unitDetails");
            return this;
        }

        public Builder valueInputDetails(ConfigurationItemAllowedValueDetails valueInputDetails) {
            this.valueInputDetails = valueInputDetails;
            this.__explicitlySet__.add("valueInputDetails");
            return this;
        }

        public BasicConfigurationItemMetadata build() {
            BasicConfigurationItemMetadata model = new BasicConfigurationItemMetadata(this.displayName, this.description, this.dataType, this.unitDetails, this.valueInputDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BasicConfigurationItemMetadata model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("unitDetails")) {
                this.unitDetails(model.getUnitDetails());
            }
            if (model.wasPropertyExplicitlySet("valueInputDetails")) {
                this.valueInputDetails(model.getValueInputDetails());
            }
            return this;
        }
    }
}

