/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiskStatistics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="diskName")
    private final String diskName;
    @JsonProperty(value="diskUnallocatedInGBs")
    private final Double diskUnallocatedInGBs;
    @JsonProperty(value="diskUsageInGBs")
    private final Double diskUsageInGBs;
    @JsonProperty(value="diskSizeInGBs")
    private final Double diskSizeInGBs;

    @Deprecated
    @ConstructorProperties(value={"diskName", "diskUnallocatedInGBs", "diskUsageInGBs", "diskSizeInGBs"})
    public DiskStatistics(String diskName, Double diskUnallocatedInGBs, Double diskUsageInGBs, Double diskSizeInGBs) {
        this.diskName = diskName;
        this.diskUnallocatedInGBs = diskUnallocatedInGBs;
        this.diskUsageInGBs = diskUsageInGBs;
        this.diskSizeInGBs = diskSizeInGBs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDiskName() {
        return this.diskName;
    }

    public Double getDiskUnallocatedInGBs() {
        return this.diskUnallocatedInGBs;
    }

    public Double getDiskUsageInGBs() {
        return this.diskUsageInGBs;
    }

    public Double getDiskSizeInGBs() {
        return this.diskSizeInGBs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiskStatistics(");
        sb.append("super=").append(super.toString());
        sb.append("diskName=").append(String.valueOf(this.diskName));
        sb.append(", diskUnallocatedInGBs=").append(String.valueOf(this.diskUnallocatedInGBs));
        sb.append(", diskUsageInGBs=").append(String.valueOf(this.diskUsageInGBs));
        sb.append(", diskSizeInGBs=").append(String.valueOf(this.diskSizeInGBs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiskStatistics)) {
            return false;
        }
        DiskStatistics other = (DiskStatistics)((Object)o);
        return Objects.equals(this.diskName, other.diskName) && Objects.equals(this.diskUnallocatedInGBs, other.diskUnallocatedInGBs) && Objects.equals(this.diskUsageInGBs, other.diskUsageInGBs) && Objects.equals(this.diskSizeInGBs, other.diskSizeInGBs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.diskName == null ? 43 : this.diskName.hashCode());
        result = result * 59 + (this.diskUnallocatedInGBs == null ? 43 : this.diskUnallocatedInGBs.hashCode());
        result = result * 59 + (this.diskUsageInGBs == null ? 43 : this.diskUsageInGBs.hashCode());
        result = result * 59 + (this.diskSizeInGBs == null ? 43 : this.diskSizeInGBs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="diskName")
        private String diskName;
        @JsonProperty(value="diskUnallocatedInGBs")
        private Double diskUnallocatedInGBs;
        @JsonProperty(value="diskUsageInGBs")
        private Double diskUsageInGBs;
        @JsonProperty(value="diskSizeInGBs")
        private Double diskSizeInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder diskName(String diskName) {
            this.diskName = diskName;
            this.__explicitlySet__.add("diskName");
            return this;
        }

        public Builder diskUnallocatedInGBs(Double diskUnallocatedInGBs) {
            this.diskUnallocatedInGBs = diskUnallocatedInGBs;
            this.__explicitlySet__.add("diskUnallocatedInGBs");
            return this;
        }

        public Builder diskUsageInGBs(Double diskUsageInGBs) {
            this.diskUsageInGBs = diskUsageInGBs;
            this.__explicitlySet__.add("diskUsageInGBs");
            return this;
        }

        public Builder diskSizeInGBs(Double diskSizeInGBs) {
            this.diskSizeInGBs = diskSizeInGBs;
            this.__explicitlySet__.add("diskSizeInGBs");
            return this;
        }

        public DiskStatistics build() {
            DiskStatistics model = new DiskStatistics(this.diskName, this.diskUnallocatedInGBs, this.diskUsageInGBs, this.diskSizeInGBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiskStatistics model) {
            if (model.wasPropertyExplicitlySet("diskName")) {
                this.diskName(model.getDiskName());
            }
            if (model.wasPropertyExplicitlySet("diskUnallocatedInGBs")) {
                this.diskUnallocatedInGBs(model.getDiskUnallocatedInGBs());
            }
            if (model.wasPropertyExplicitlySet("diskUsageInGBs")) {
                this.diskUsageInGBs(model.getDiskUsageInGBs());
            }
            if (model.wasPropertyExplicitlySet("diskSizeInGBs")) {
                this.diskSizeInGBs(model.getDiskSizeInGBs());
            }
            return this;
        }
    }
}

