/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.EmManagedExternalHostConfigurationSummary;
import com.oracle.bmc.opsi.model.MacsManagedCloudHostConfigurationSummary;
import com.oracle.bmc.opsi.model.MacsManagedExternalHostConfigurationSummary;
import com.oracle.bmc.opsi.model.PeComanagedHostConfigurationSummary;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entitySource", defaultImpl=HostConfigurationSummary.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MacsManagedExternalHostConfigurationSummary.class, name="MACS_MANAGED_EXTERNAL_HOST"), @JsonSubTypes.Type(value=PeComanagedHostConfigurationSummary.class, name="PE_COMANAGED_HOST"), @JsonSubTypes.Type(value=EmManagedExternalHostConfigurationSummary.class, name="EM_MANAGED_EXTERNAL_HOST"), @JsonSubTypes.Type(value=MacsManagedCloudHostConfigurationSummary.class, name="MACS_MANAGED_CLOUD_HOST")})
@JsonFilter(value="explicitlySetFilter")
public class HostConfigurationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostInsightId")
    private final String hostInsightId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="platformType")
    private final PlatformType platformType;
    @JsonProperty(value="platformVersion")
    private final String platformVersion;
    @JsonProperty(value="platformVendor")
    private final String platformVendor;
    @JsonProperty(value="totalCpus")
    private final Integer totalCpus;
    @JsonProperty(value="totalMemoryInGBs")
    private final Double totalMemoryInGBs;
    @JsonProperty(value="cpuArchitecture")
    private final String cpuArchitecture;
    @JsonProperty(value="cpuCacheInMBs")
    private final Double cpuCacheInMBs;
    @JsonProperty(value="cpuVendor")
    private final String cpuVendor;
    @JsonProperty(value="cpuFrequencyInMhz")
    private final Double cpuFrequencyInMhz;
    @JsonProperty(value="cpuImplementation")
    private final String cpuImplementation;
    @JsonProperty(value="coresPerSocket")
    private final Integer coresPerSocket;
    @JsonProperty(value="totalSockets")
    private final Integer totalSockets;
    @JsonProperty(value="threadsPerSocket")
    private final Integer threadsPerSocket;
    @JsonProperty(value="isHyperThreadingEnabled")
    private final Boolean isHyperThreadingEnabled;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;

    @Deprecated
    @ConstructorProperties(value={"hostInsightId", "compartmentId", "hostName", "platformType", "platformVersion", "platformVendor", "totalCpus", "totalMemoryInGBs", "cpuArchitecture", "cpuCacheInMBs", "cpuVendor", "cpuFrequencyInMhz", "cpuImplementation", "coresPerSocket", "totalSockets", "threadsPerSocket", "isHyperThreadingEnabled", "definedTags", "freeformTags"})
    protected HostConfigurationSummary(String hostInsightId, String compartmentId, String hostName, PlatformType platformType, String platformVersion, String platformVendor, Integer totalCpus, Double totalMemoryInGBs, String cpuArchitecture, Double cpuCacheInMBs, String cpuVendor, Double cpuFrequencyInMhz, String cpuImplementation, Integer coresPerSocket, Integer totalSockets, Integer threadsPerSocket, Boolean isHyperThreadingEnabled, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags) {
        this.hostInsightId = hostInsightId;
        this.compartmentId = compartmentId;
        this.hostName = hostName;
        this.platformType = platformType;
        this.platformVersion = platformVersion;
        this.platformVendor = platformVendor;
        this.totalCpus = totalCpus;
        this.totalMemoryInGBs = totalMemoryInGBs;
        this.cpuArchitecture = cpuArchitecture;
        this.cpuCacheInMBs = cpuCacheInMBs;
        this.cpuVendor = cpuVendor;
        this.cpuFrequencyInMhz = cpuFrequencyInMhz;
        this.cpuImplementation = cpuImplementation;
        this.coresPerSocket = coresPerSocket;
        this.totalSockets = totalSockets;
        this.threadsPerSocket = threadsPerSocket;
        this.isHyperThreadingEnabled = isHyperThreadingEnabled;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
    }

    public String getHostInsightId() {
        return this.hostInsightId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getPlatformVendor() {
        return this.platformVendor;
    }

    public Integer getTotalCpus() {
        return this.totalCpus;
    }

    public Double getTotalMemoryInGBs() {
        return this.totalMemoryInGBs;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public Double getCpuCacheInMBs() {
        return this.cpuCacheInMBs;
    }

    public String getCpuVendor() {
        return this.cpuVendor;
    }

    public Double getCpuFrequencyInMhz() {
        return this.cpuFrequencyInMhz;
    }

    public String getCpuImplementation() {
        return this.cpuImplementation;
    }

    public Integer getCoresPerSocket() {
        return this.coresPerSocket;
    }

    public Integer getTotalSockets() {
        return this.totalSockets;
    }

    public Integer getThreadsPerSocket() {
        return this.threadsPerSocket;
    }

    public Boolean getIsHyperThreadingEnabled() {
        return this.isHyperThreadingEnabled;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostConfigurationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("hostInsightId=").append(String.valueOf(this.hostInsightId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", hostName=").append(String.valueOf(this.hostName));
        sb.append(", platformType=").append(String.valueOf((Object)this.platformType));
        sb.append(", platformVersion=").append(String.valueOf(this.platformVersion));
        sb.append(", platformVendor=").append(String.valueOf(this.platformVendor));
        sb.append(", totalCpus=").append(String.valueOf(this.totalCpus));
        sb.append(", totalMemoryInGBs=").append(String.valueOf(this.totalMemoryInGBs));
        sb.append(", cpuArchitecture=").append(String.valueOf(this.cpuArchitecture));
        sb.append(", cpuCacheInMBs=").append(String.valueOf(this.cpuCacheInMBs));
        sb.append(", cpuVendor=").append(String.valueOf(this.cpuVendor));
        sb.append(", cpuFrequencyInMhz=").append(String.valueOf(this.cpuFrequencyInMhz));
        sb.append(", cpuImplementation=").append(String.valueOf(this.cpuImplementation));
        sb.append(", coresPerSocket=").append(String.valueOf(this.coresPerSocket));
        sb.append(", totalSockets=").append(String.valueOf(this.totalSockets));
        sb.append(", threadsPerSocket=").append(String.valueOf(this.threadsPerSocket));
        sb.append(", isHyperThreadingEnabled=").append(String.valueOf(this.isHyperThreadingEnabled));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostConfigurationSummary)) {
            return false;
        }
        HostConfigurationSummary other = (HostConfigurationSummary)((Object)o);
        return Objects.equals(this.hostInsightId, other.hostInsightId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.hostName, other.hostName) && Objects.equals((Object)this.platformType, (Object)other.platformType) && Objects.equals(this.platformVersion, other.platformVersion) && Objects.equals(this.platformVendor, other.platformVendor) && Objects.equals(this.totalCpus, other.totalCpus) && Objects.equals(this.totalMemoryInGBs, other.totalMemoryInGBs) && Objects.equals(this.cpuArchitecture, other.cpuArchitecture) && Objects.equals(this.cpuCacheInMBs, other.cpuCacheInMBs) && Objects.equals(this.cpuVendor, other.cpuVendor) && Objects.equals(this.cpuFrequencyInMhz, other.cpuFrequencyInMhz) && Objects.equals(this.cpuImplementation, other.cpuImplementation) && Objects.equals(this.coresPerSocket, other.coresPerSocket) && Objects.equals(this.totalSockets, other.totalSockets) && Objects.equals(this.threadsPerSocket, other.threadsPerSocket) && Objects.equals(this.isHyperThreadingEnabled, other.isHyperThreadingEnabled) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostInsightId == null ? 43 : this.hostInsightId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.platformType == null ? 43 : this.platformType.hashCode());
        result = result * 59 + (this.platformVersion == null ? 43 : this.platformVersion.hashCode());
        result = result * 59 + (this.platformVendor == null ? 43 : this.platformVendor.hashCode());
        result = result * 59 + (this.totalCpus == null ? 43 : this.totalCpus.hashCode());
        result = result * 59 + (this.totalMemoryInGBs == null ? 43 : this.totalMemoryInGBs.hashCode());
        result = result * 59 + (this.cpuArchitecture == null ? 43 : this.cpuArchitecture.hashCode());
        result = result * 59 + (this.cpuCacheInMBs == null ? 43 : this.cpuCacheInMBs.hashCode());
        result = result * 59 + (this.cpuVendor == null ? 43 : this.cpuVendor.hashCode());
        result = result * 59 + (this.cpuFrequencyInMhz == null ? 43 : this.cpuFrequencyInMhz.hashCode());
        result = result * 59 + (this.cpuImplementation == null ? 43 : this.cpuImplementation.hashCode());
        result = result * 59 + (this.coresPerSocket == null ? 43 : this.coresPerSocket.hashCode());
        result = result * 59 + (this.totalSockets == null ? 43 : this.totalSockets.hashCode());
        result = result * 59 + (this.threadsPerSocket == null ? 43 : this.threadsPerSocket.hashCode());
        result = result * 59 + (this.isHyperThreadingEnabled == null ? 43 : this.isHyperThreadingEnabled.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PlatformType implements BmcEnum
    {
        Linux("LINUX"),
        Solaris("SOLARIS"),
        Sunos("SUNOS"),
        Zlinux("ZLINUX"),
        Windows("WINDOWS"),
        Aix("AIX"),
        HpUx("HP_UX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlatformType> map;

        private PlatformType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlatformType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlatformType.class);
            map = new HashMap<String, PlatformType>();
            for (PlatformType v : PlatformType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

