/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostCpuHardwareConfiguration
extends HostConfigurationMetricGroup {
    @JsonProperty(value="totalSockets")
    private final Integer totalSockets;
    @JsonProperty(value="vendorName")
    private final String vendorName;
    @JsonProperty(value="frequencyInMhz")
    private final Double frequencyInMhz;
    @JsonProperty(value="cacheInMB")
    private final Double cacheInMB;
    @JsonProperty(value="cpuImplementation")
    private final String cpuImplementation;
    @JsonProperty(value="model")
    private final String model;
    @JsonProperty(value="cpuFamily")
    private final String cpuFamily;
    @JsonProperty(value="coresPerSocket")
    private final Integer coresPerSocket;
    @JsonProperty(value="threadsPerSocket")
    private final Integer threadsPerSocket;
    @JsonProperty(value="hyperThreadingEnabled")
    private final String hyperThreadingEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostCpuHardwareConfiguration(Date timeCollected, Integer totalSockets, String vendorName, Double frequencyInMhz, Double cacheInMB, String cpuImplementation, String model, String cpuFamily, Integer coresPerSocket, Integer threadsPerSocket, String hyperThreadingEnabled) {
        super(timeCollected);
        this.totalSockets = totalSockets;
        this.vendorName = vendorName;
        this.frequencyInMhz = frequencyInMhz;
        this.cacheInMB = cacheInMB;
        this.cpuImplementation = cpuImplementation;
        this.model = model;
        this.cpuFamily = cpuFamily;
        this.coresPerSocket = coresPerSocket;
        this.threadsPerSocket = threadsPerSocket;
        this.hyperThreadingEnabled = hyperThreadingEnabled;
    }

    public Integer getTotalSockets() {
        return this.totalSockets;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public Double getFrequencyInMhz() {
        return this.frequencyInMhz;
    }

    public Double getCacheInMB() {
        return this.cacheInMB;
    }

    public String getCpuImplementation() {
        return this.cpuImplementation;
    }

    public String getModel() {
        return this.model;
    }

    public String getCpuFamily() {
        return this.cpuFamily;
    }

    public Integer getCoresPerSocket() {
        return this.coresPerSocket;
    }

    public Integer getThreadsPerSocket() {
        return this.threadsPerSocket;
    }

    public String getHyperThreadingEnabled() {
        return this.hyperThreadingEnabled;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostCpuHardwareConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", totalSockets=").append(String.valueOf(this.totalSockets));
        sb.append(", vendorName=").append(String.valueOf(this.vendorName));
        sb.append(", frequencyInMhz=").append(String.valueOf(this.frequencyInMhz));
        sb.append(", cacheInMB=").append(String.valueOf(this.cacheInMB));
        sb.append(", cpuImplementation=").append(String.valueOf(this.cpuImplementation));
        sb.append(", model=").append(String.valueOf(this.model));
        sb.append(", cpuFamily=").append(String.valueOf(this.cpuFamily));
        sb.append(", coresPerSocket=").append(String.valueOf(this.coresPerSocket));
        sb.append(", threadsPerSocket=").append(String.valueOf(this.threadsPerSocket));
        sb.append(", hyperThreadingEnabled=").append(String.valueOf(this.hyperThreadingEnabled));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostCpuHardwareConfiguration)) {
            return false;
        }
        HostCpuHardwareConfiguration other = (HostCpuHardwareConfiguration)((Object)o);
        return Objects.equals(this.totalSockets, other.totalSockets) && Objects.equals(this.vendorName, other.vendorName) && Objects.equals(this.frequencyInMhz, other.frequencyInMhz) && Objects.equals(this.cacheInMB, other.cacheInMB) && Objects.equals(this.cpuImplementation, other.cpuImplementation) && Objects.equals(this.model, other.model) && Objects.equals(this.cpuFamily, other.cpuFamily) && Objects.equals(this.coresPerSocket, other.coresPerSocket) && Objects.equals(this.threadsPerSocket, other.threadsPerSocket) && Objects.equals(this.hyperThreadingEnabled, other.hyperThreadingEnabled) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.totalSockets == null ? 43 : this.totalSockets.hashCode());
        result = result * 59 + (this.vendorName == null ? 43 : this.vendorName.hashCode());
        result = result * 59 + (this.frequencyInMhz == null ? 43 : this.frequencyInMhz.hashCode());
        result = result * 59 + (this.cacheInMB == null ? 43 : this.cacheInMB.hashCode());
        result = result * 59 + (this.cpuImplementation == null ? 43 : this.cpuImplementation.hashCode());
        result = result * 59 + (this.model == null ? 43 : this.model.hashCode());
        result = result * 59 + (this.cpuFamily == null ? 43 : this.cpuFamily.hashCode());
        result = result * 59 + (this.coresPerSocket == null ? 43 : this.coresPerSocket.hashCode());
        result = result * 59 + (this.threadsPerSocket == null ? 43 : this.threadsPerSocket.hashCode());
        result = result * 59 + (this.hyperThreadingEnabled == null ? 43 : this.hyperThreadingEnabled.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="totalSockets")
        private Integer totalSockets;
        @JsonProperty(value="vendorName")
        private String vendorName;
        @JsonProperty(value="frequencyInMhz")
        private Double frequencyInMhz;
        @JsonProperty(value="cacheInMB")
        private Double cacheInMB;
        @JsonProperty(value="cpuImplementation")
        private String cpuImplementation;
        @JsonProperty(value="model")
        private String model;
        @JsonProperty(value="cpuFamily")
        private String cpuFamily;
        @JsonProperty(value="coresPerSocket")
        private Integer coresPerSocket;
        @JsonProperty(value="threadsPerSocket")
        private Integer threadsPerSocket;
        @JsonProperty(value="hyperThreadingEnabled")
        private String hyperThreadingEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder totalSockets(Integer totalSockets) {
            this.totalSockets = totalSockets;
            this.__explicitlySet__.add("totalSockets");
            return this;
        }

        public Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            this.__explicitlySet__.add("vendorName");
            return this;
        }

        public Builder frequencyInMhz(Double frequencyInMhz) {
            this.frequencyInMhz = frequencyInMhz;
            this.__explicitlySet__.add("frequencyInMhz");
            return this;
        }

        public Builder cacheInMB(Double cacheInMB) {
            this.cacheInMB = cacheInMB;
            this.__explicitlySet__.add("cacheInMB");
            return this;
        }

        public Builder cpuImplementation(String cpuImplementation) {
            this.cpuImplementation = cpuImplementation;
            this.__explicitlySet__.add("cpuImplementation");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.__explicitlySet__.add("model");
            return this;
        }

        public Builder cpuFamily(String cpuFamily) {
            this.cpuFamily = cpuFamily;
            this.__explicitlySet__.add("cpuFamily");
            return this;
        }

        public Builder coresPerSocket(Integer coresPerSocket) {
            this.coresPerSocket = coresPerSocket;
            this.__explicitlySet__.add("coresPerSocket");
            return this;
        }

        public Builder threadsPerSocket(Integer threadsPerSocket) {
            this.threadsPerSocket = threadsPerSocket;
            this.__explicitlySet__.add("threadsPerSocket");
            return this;
        }

        public Builder hyperThreadingEnabled(String hyperThreadingEnabled) {
            this.hyperThreadingEnabled = hyperThreadingEnabled;
            this.__explicitlySet__.add("hyperThreadingEnabled");
            return this;
        }

        public HostCpuHardwareConfiguration build() {
            HostCpuHardwareConfiguration model = new HostCpuHardwareConfiguration(this.timeCollected, this.totalSockets, this.vendorName, this.frequencyInMhz, this.cacheInMB, this.cpuImplementation, this.model, this.cpuFamily, this.coresPerSocket, this.threadsPerSocket, this.hyperThreadingEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostCpuHardwareConfiguration model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("totalSockets")) {
                this.totalSockets(model.getTotalSockets());
            }
            if (model.wasPropertyExplicitlySet("vendorName")) {
                this.vendorName(model.getVendorName());
            }
            if (model.wasPropertyExplicitlySet("frequencyInMhz")) {
                this.frequencyInMhz(model.getFrequencyInMhz());
            }
            if (model.wasPropertyExplicitlySet("cacheInMB")) {
                this.cacheInMB(model.getCacheInMB());
            }
            if (model.wasPropertyExplicitlySet("cpuImplementation")) {
                this.cpuImplementation(model.getCpuImplementation());
            }
            if (model.wasPropertyExplicitlySet("model")) {
                this.model(model.getModel());
            }
            if (model.wasPropertyExplicitlySet("cpuFamily")) {
                this.cpuFamily(model.getCpuFamily());
            }
            if (model.wasPropertyExplicitlySet("coresPerSocket")) {
                this.coresPerSocket(model.getCoresPerSocket());
            }
            if (model.wasPropertyExplicitlySet("threadsPerSocket")) {
                this.threadsPerSocket(model.getThreadsPerSocket());
            }
            if (model.wasPropertyExplicitlySet("hyperThreadingEnabled")) {
                this.hyperThreadingEnabled(model.getHyperThreadingEnabled());
            }
            return this;
        }
    }
}

