/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkUsageTrend
extends ExplicitlySetBmcModel {
    @JsonProperty(value="endTimestamp")
    private final Date endTimestamp;
    @JsonProperty(value="allNetworkReadInMbps")
    private final Double allNetworkReadInMbps;
    @JsonProperty(value="allNetworkWriteInMbps")
    private final Double allNetworkWriteInMbps;
    @JsonProperty(value="allNetworkIoInMbps")
    private final Double allNetworkIoInMbps;

    @Deprecated
    @ConstructorProperties(value={"endTimestamp", "allNetworkReadInMbps", "allNetworkWriteInMbps", "allNetworkIoInMbps"})
    public NetworkUsageTrend(Date endTimestamp, Double allNetworkReadInMbps, Double allNetworkWriteInMbps, Double allNetworkIoInMbps) {
        this.endTimestamp = endTimestamp;
        this.allNetworkReadInMbps = allNetworkReadInMbps;
        this.allNetworkWriteInMbps = allNetworkWriteInMbps;
        this.allNetworkIoInMbps = allNetworkIoInMbps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public Double getAllNetworkReadInMbps() {
        return this.allNetworkReadInMbps;
    }

    public Double getAllNetworkWriteInMbps() {
        return this.allNetworkWriteInMbps;
    }

    public Double getAllNetworkIoInMbps() {
        return this.allNetworkIoInMbps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkUsageTrend(");
        sb.append("super=").append(super.toString());
        sb.append("endTimestamp=").append(String.valueOf(this.endTimestamp));
        sb.append(", allNetworkReadInMbps=").append(String.valueOf(this.allNetworkReadInMbps));
        sb.append(", allNetworkWriteInMbps=").append(String.valueOf(this.allNetworkWriteInMbps));
        sb.append(", allNetworkIoInMbps=").append(String.valueOf(this.allNetworkIoInMbps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkUsageTrend)) {
            return false;
        }
        NetworkUsageTrend other = (NetworkUsageTrend)((Object)o);
        return Objects.equals(this.endTimestamp, other.endTimestamp) && Objects.equals(this.allNetworkReadInMbps, other.allNetworkReadInMbps) && Objects.equals(this.allNetworkWriteInMbps, other.allNetworkWriteInMbps) && Objects.equals(this.allNetworkIoInMbps, other.allNetworkIoInMbps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.endTimestamp == null ? 43 : this.endTimestamp.hashCode());
        result = result * 59 + (this.allNetworkReadInMbps == null ? 43 : this.allNetworkReadInMbps.hashCode());
        result = result * 59 + (this.allNetworkWriteInMbps == null ? 43 : this.allNetworkWriteInMbps.hashCode());
        result = result * 59 + (this.allNetworkIoInMbps == null ? 43 : this.allNetworkIoInMbps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="endTimestamp")
        private Date endTimestamp;
        @JsonProperty(value="allNetworkReadInMbps")
        private Double allNetworkReadInMbps;
        @JsonProperty(value="allNetworkWriteInMbps")
        private Double allNetworkWriteInMbps;
        @JsonProperty(value="allNetworkIoInMbps")
        private Double allNetworkIoInMbps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder endTimestamp(Date endTimestamp) {
            this.endTimestamp = endTimestamp;
            this.__explicitlySet__.add("endTimestamp");
            return this;
        }

        public Builder allNetworkReadInMbps(Double allNetworkReadInMbps) {
            this.allNetworkReadInMbps = allNetworkReadInMbps;
            this.__explicitlySet__.add("allNetworkReadInMbps");
            return this;
        }

        public Builder allNetworkWriteInMbps(Double allNetworkWriteInMbps) {
            this.allNetworkWriteInMbps = allNetworkWriteInMbps;
            this.__explicitlySet__.add("allNetworkWriteInMbps");
            return this;
        }

        public Builder allNetworkIoInMbps(Double allNetworkIoInMbps) {
            this.allNetworkIoInMbps = allNetworkIoInMbps;
            this.__explicitlySet__.add("allNetworkIoInMbps");
            return this;
        }

        public NetworkUsageTrend build() {
            NetworkUsageTrend model = new NetworkUsageTrend(this.endTimestamp, this.allNetworkReadInMbps, this.allNetworkWriteInMbps, this.allNetworkIoInMbps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkUsageTrend model) {
            if (model.wasPropertyExplicitlySet("endTimestamp")) {
                this.endTimestamp(model.getEndTimestamp());
            }
            if (model.wasPropertyExplicitlySet("allNetworkReadInMbps")) {
                this.allNetworkReadInMbps(model.getAllNetworkReadInMbps());
            }
            if (model.wasPropertyExplicitlySet("allNetworkWriteInMbps")) {
                this.allNetworkWriteInMbps(model.getAllNetworkWriteInMbps());
            }
            if (model.wasPropertyExplicitlySet("allNetworkIoInMbps")) {
                this.allNetworkIoInMbps(model.getAllNetworkIoInMbps());
            }
            return this;
        }
    }
}

