/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.ArchivalState;
import com.oracle.bmc.opsi.model.StorageTier;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ObjectSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="size")
    private final Long size;
    @JsonProperty(value="md5")
    private final String md5;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="etag")
    private final String etag;
    @JsonProperty(value="storageTier")
    private final StorageTier storageTier;
    @JsonProperty(value="archivalState")
    private final ArchivalState archivalState;
    @JsonProperty(value="timeModified")
    private final Date timeModified;

    @Deprecated
    @ConstructorProperties(value={"name", "size", "md5", "timeCreated", "etag", "storageTier", "archivalState", "timeModified"})
    public ObjectSummary(String name, Long size, String md5, Date timeCreated, String etag, StorageTier storageTier, ArchivalState archivalState, Date timeModified) {
        this.name = name;
        this.size = size;
        this.md5 = md5;
        this.timeCreated = timeCreated;
        this.etag = etag;
        this.storageTier = storageTier;
        this.archivalState = archivalState;
        this.timeModified = timeModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Long getSize() {
        return this.size;
    }

    public String getMd5() {
        return this.md5;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getEtag() {
        return this.etag;
    }

    public StorageTier getStorageTier() {
        return this.storageTier;
    }

    public ArchivalState getArchivalState() {
        return this.archivalState;
    }

    public Date getTimeModified() {
        return this.timeModified;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", size=").append(String.valueOf(this.size));
        sb.append(", md5=").append(String.valueOf(this.md5));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", etag=").append(String.valueOf(this.etag));
        sb.append(", storageTier=").append(String.valueOf((Object)this.storageTier));
        sb.append(", archivalState=").append(String.valueOf((Object)this.archivalState));
        sb.append(", timeModified=").append(String.valueOf(this.timeModified));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectSummary)) {
            return false;
        }
        ObjectSummary other = (ObjectSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.size, other.size) && Objects.equals(this.md5, other.md5) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.storageTier, (Object)other.storageTier) && Objects.equals((Object)this.archivalState, (Object)other.archivalState) && Objects.equals(this.timeModified, other.timeModified) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.size == null ? 43 : this.size.hashCode());
        result = result * 59 + (this.md5 == null ? 43 : this.md5.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.storageTier == null ? 43 : this.storageTier.hashCode());
        result = result * 59 + (this.archivalState == null ? 43 : this.archivalState.hashCode());
        result = result * 59 + (this.timeModified == null ? 43 : this.timeModified.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="size")
        private Long size;
        @JsonProperty(value="md5")
        private String md5;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="etag")
        private String etag;
        @JsonProperty(value="storageTier")
        private StorageTier storageTier;
        @JsonProperty(value="archivalState")
        private ArchivalState archivalState;
        @JsonProperty(value="timeModified")
        private Date timeModified;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.__explicitlySet__.add("size");
            return this;
        }

        public Builder md5(String md5) {
            this.md5 = md5;
            this.__explicitlySet__.add("md5");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            this.__explicitlySet__.add("etag");
            return this;
        }

        public Builder storageTier(StorageTier storageTier) {
            this.storageTier = storageTier;
            this.__explicitlySet__.add("storageTier");
            return this;
        }

        public Builder archivalState(ArchivalState archivalState) {
            this.archivalState = archivalState;
            this.__explicitlySet__.add("archivalState");
            return this;
        }

        public Builder timeModified(Date timeModified) {
            this.timeModified = timeModified;
            this.__explicitlySet__.add("timeModified");
            return this;
        }

        public ObjectSummary build() {
            ObjectSummary model = new ObjectSummary(this.name, this.size, this.md5, this.timeCreated, this.etag, this.storageTier, this.archivalState, this.timeModified);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("size")) {
                this.size(model.getSize());
            }
            if (model.wasPropertyExplicitlySet("md5")) {
                this.md5(model.getMd5());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("etag")) {
                this.etag(model.getEtag());
            }
            if (model.wasPropertyExplicitlySet("storageTier")) {
                this.storageTier(model.getStorageTier());
            }
            if (model.wasPropertyExplicitlySet("archivalState")) {
                this.archivalState(model.getArchivalState());
            }
            if (model.wasPropertyExplicitlySet("timeModified")) {
                this.timeModified(model.getTimeModified());
            }
            return this;
        }
    }
}

