/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.DataObjectQuery;
import com.oracle.bmc.opsi.model.OpsiDataObjectDetailsInQuery;
import com.oracle.bmc.opsi.model.ResourceFilters;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryOpsiDataObjectDataDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dataObjectIdentifier")
    private final String dataObjectIdentifier;
    @JsonProperty(value="dataObjects")
    private final List<OpsiDataObjectDetailsInQuery> dataObjects;
    @JsonProperty(value="query")
    private final DataObjectQuery query;
    @JsonProperty(value="resourceFilters")
    private final ResourceFilters resourceFilters;

    @Deprecated
    @ConstructorProperties(value={"dataObjectIdentifier", "dataObjects", "query", "resourceFilters"})
    public QueryOpsiDataObjectDataDetails(String dataObjectIdentifier, List<OpsiDataObjectDetailsInQuery> dataObjects, DataObjectQuery query, ResourceFilters resourceFilters) {
        this.dataObjectIdentifier = dataObjectIdentifier;
        this.dataObjects = dataObjects;
        this.query = query;
        this.resourceFilters = resourceFilters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDataObjectIdentifier() {
        return this.dataObjectIdentifier;
    }

    public List<OpsiDataObjectDetailsInQuery> getDataObjects() {
        return this.dataObjects;
    }

    public DataObjectQuery getQuery() {
        return this.query;
    }

    public ResourceFilters getResourceFilters() {
        return this.resourceFilters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryOpsiDataObjectDataDetails(");
        sb.append("super=").append(super.toString());
        sb.append("dataObjectIdentifier=").append(String.valueOf(this.dataObjectIdentifier));
        sb.append(", dataObjects=").append(String.valueOf(this.dataObjects));
        sb.append(", query=").append(String.valueOf((Object)this.query));
        sb.append(", resourceFilters=").append(String.valueOf((Object)this.resourceFilters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryOpsiDataObjectDataDetails)) {
            return false;
        }
        QueryOpsiDataObjectDataDetails other = (QueryOpsiDataObjectDataDetails)((Object)o);
        return Objects.equals(this.dataObjectIdentifier, other.dataObjectIdentifier) && Objects.equals(this.dataObjects, other.dataObjects) && Objects.equals((Object)this.query, (Object)other.query) && Objects.equals((Object)this.resourceFilters, (Object)other.resourceFilters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dataObjectIdentifier == null ? 43 : this.dataObjectIdentifier.hashCode());
        result = result * 59 + (this.dataObjects == null ? 43 : this.dataObjects.hashCode());
        result = result * 59 + (this.query == null ? 43 : this.query.hashCode());
        result = result * 59 + (this.resourceFilters == null ? 43 : this.resourceFilters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dataObjectIdentifier")
        private String dataObjectIdentifier;
        @JsonProperty(value="dataObjects")
        private List<OpsiDataObjectDetailsInQuery> dataObjects;
        @JsonProperty(value="query")
        private DataObjectQuery query;
        @JsonProperty(value="resourceFilters")
        private ResourceFilters resourceFilters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dataObjectIdentifier(String dataObjectIdentifier) {
            this.dataObjectIdentifier = dataObjectIdentifier;
            this.__explicitlySet__.add("dataObjectIdentifier");
            return this;
        }

        public Builder dataObjects(List<OpsiDataObjectDetailsInQuery> dataObjects) {
            this.dataObjects = dataObjects;
            this.__explicitlySet__.add("dataObjects");
            return this;
        }

        public Builder query(DataObjectQuery query) {
            this.query = query;
            this.__explicitlySet__.add("query");
            return this;
        }

        public Builder resourceFilters(ResourceFilters resourceFilters) {
            this.resourceFilters = resourceFilters;
            this.__explicitlySet__.add("resourceFilters");
            return this;
        }

        public QueryOpsiDataObjectDataDetails build() {
            QueryOpsiDataObjectDataDetails model = new QueryOpsiDataObjectDataDetails(this.dataObjectIdentifier, this.dataObjects, this.query, this.resourceFilters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryOpsiDataObjectDataDetails model) {
            if (model.wasPropertyExplicitlySet("dataObjectIdentifier")) {
                this.dataObjectIdentifier(model.getDataObjectIdentifier());
            }
            if (model.wasPropertyExplicitlySet("dataObjects")) {
                this.dataObjects(model.getDataObjects());
            }
            if (model.wasPropertyExplicitlySet("query")) {
                this.query(model.getQuery());
            }
            if (model.wasPropertyExplicitlySet("resourceFilters")) {
                this.resourceFilters(model.getResourceFilters());
            }
            return this;
        }
    }
}

