/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.CreateOpsiConfigurationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateOpsiConfigurationRequest
extends BmcRequest<CreateOpsiConfigurationDetails> {
    private CreateOpsiConfigurationDetails createOpsiConfigurationDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private List<OpsiConfigField> opsiConfigField;
    private List<ConfigItemCustomStatus> configItemCustomStatus;
    private List<String> configItemsApplicableContext;
    private List<ConfigItemField> configItemField;

    public CreateOpsiConfigurationDetails getCreateOpsiConfigurationDetails() {
        return this.createOpsiConfigurationDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<OpsiConfigField> getOpsiConfigField() {
        return this.opsiConfigField;
    }

    public List<ConfigItemCustomStatus> getConfigItemCustomStatus() {
        return this.configItemCustomStatus;
    }

    public List<String> getConfigItemsApplicableContext() {
        return this.configItemsApplicableContext;
    }

    public List<ConfigItemField> getConfigItemField() {
        return this.configItemField;
    }

    @InternalSdk
    public CreateOpsiConfigurationDetails getBody$() {
        return this.createOpsiConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().createOpsiConfigurationDetails(this.createOpsiConfigurationDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).opsiConfigField(this.opsiConfigField).configItemCustomStatus(this.configItemCustomStatus).configItemsApplicableContext(this.configItemsApplicableContext).configItemField(this.configItemField);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createOpsiConfigurationDetails=").append(String.valueOf((Object)this.createOpsiConfigurationDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opsiConfigField=").append(String.valueOf(this.opsiConfigField));
        sb.append(",configItemCustomStatus=").append(String.valueOf(this.configItemCustomStatus));
        sb.append(",configItemsApplicableContext=").append(String.valueOf(this.configItemsApplicableContext));
        sb.append(",configItemField=").append(String.valueOf(this.configItemField));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOpsiConfigurationRequest)) {
            return false;
        }
        CreateOpsiConfigurationRequest other = (CreateOpsiConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createOpsiConfigurationDetails, (Object)other.createOpsiConfigurationDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opsiConfigField, other.opsiConfigField) && Objects.equals(this.configItemCustomStatus, other.configItemCustomStatus) && Objects.equals(this.configItemsApplicableContext, other.configItemsApplicableContext) && Objects.equals(this.configItemField, other.configItemField);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createOpsiConfigurationDetails == null ? 43 : this.createOpsiConfigurationDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opsiConfigField == null ? 43 : this.opsiConfigField.hashCode());
        result = result * 59 + (this.configItemCustomStatus == null ? 43 : this.configItemCustomStatus.hashCode());
        result = result * 59 + (this.configItemsApplicableContext == null ? 43 : this.configItemsApplicableContext.hashCode());
        result = result * 59 + (this.configItemField == null ? 43 : this.configItemField.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateOpsiConfigurationRequest, CreateOpsiConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateOpsiConfigurationDetails createOpsiConfigurationDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private List<OpsiConfigField> opsiConfigField = null;
        private List<ConfigItemCustomStatus> configItemCustomStatus = null;
        private List<String> configItemsApplicableContext = null;
        private List<ConfigItemField> configItemField = null;

        public Builder createOpsiConfigurationDetails(CreateOpsiConfigurationDetails createOpsiConfigurationDetails) {
            this.createOpsiConfigurationDetails = createOpsiConfigurationDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opsiConfigField(List<OpsiConfigField> opsiConfigField) {
            this.opsiConfigField = opsiConfigField;
            return this;
        }

        public Builder opsiConfigField(OpsiConfigField singularValue) {
            return this.opsiConfigField(Arrays.asList(singularValue));
        }

        public Builder configItemCustomStatus(List<ConfigItemCustomStatus> configItemCustomStatus) {
            this.configItemCustomStatus = configItemCustomStatus;
            return this;
        }

        public Builder configItemCustomStatus(ConfigItemCustomStatus singularValue) {
            return this.configItemCustomStatus(Arrays.asList(singularValue));
        }

        public Builder configItemsApplicableContext(List<String> configItemsApplicableContext) {
            this.configItemsApplicableContext = configItemsApplicableContext;
            return this;
        }

        public Builder configItemsApplicableContext(String singularValue) {
            return this.configItemsApplicableContext(Arrays.asList(singularValue));
        }

        public Builder configItemField(List<ConfigItemField> configItemField) {
            this.configItemField = configItemField;
            return this;
        }

        public Builder configItemField(ConfigItemField singularValue) {
            return this.configItemField(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateOpsiConfigurationRequest o) {
            this.createOpsiConfigurationDetails(o.getCreateOpsiConfigurationDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.opsiConfigField(o.getOpsiConfigField());
            this.configItemCustomStatus(o.getConfigItemCustomStatus());
            this.configItemsApplicableContext(o.getConfigItemsApplicableContext());
            this.configItemField(o.getConfigItemField());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateOpsiConfigurationRequest build() {
            CreateOpsiConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateOpsiConfigurationDetails body) {
            this.createOpsiConfigurationDetails(body);
            return this;
        }

        public CreateOpsiConfigurationRequest buildWithoutInvocationCallback() {
            CreateOpsiConfigurationRequest request = new CreateOpsiConfigurationRequest();
            request.createOpsiConfigurationDetails = this.createOpsiConfigurationDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.opsiConfigField = this.opsiConfigField;
            request.configItemCustomStatus = this.configItemCustomStatus;
            request.configItemsApplicableContext = this.configItemsApplicableContext;
            request.configItemField = this.configItemField;
            return request;
        }
    }

    public static enum ConfigItemField implements BmcEnum
    {
        Name("name"),
        Value("value"),
        DefaultValue("defaultValue"),
        Metadata("metadata"),
        ApplicableContexts("applicableContexts");

        private final String value;
        private static Map<String, ConfigItemField> map;

        private ConfigItemField(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfigItemField create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ConfigItemField: " + key);
        }

        static {
            map = new HashMap<String, ConfigItemField>();
            for (ConfigItemField v : ConfigItemField.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ConfigItemCustomStatus implements BmcEnum
    {
        Customized("customized"),
        NonCustomized("nonCustomized");

        private final String value;
        private static Map<String, ConfigItemCustomStatus> map;

        private ConfigItemCustomStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfigItemCustomStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ConfigItemCustomStatus: " + key);
        }

        static {
            map = new HashMap<String, ConfigItemCustomStatus>();
            for (ConfigItemCustomStatus v : ConfigItemCustomStatus.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OpsiConfigField implements BmcEnum
    {
        ConfigItems("configItems");

        private final String value;
        private static Map<String, OpsiConfigField> map;

        private OpsiConfigField(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OpsiConfigField create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid OpsiConfigField: " + key);
        }

        static {
            map = new HashMap<String, OpsiConfigField>();
            for (OpsiConfigField v : OpsiConfigField.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

