/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.opsi.model.QueryOpsiDataObjectDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class QueryOpsiDataObjectDataRequest
extends BmcRequest<QueryOpsiDataObjectDataDetails> {
    private String compartmentId;
    private QueryOpsiDataObjectDataDetails queryOpsiDataObjectDataDetails;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public QueryOpsiDataObjectDataDetails getQueryOpsiDataObjectDataDetails() {
        return this.queryOpsiDataObjectDataDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public QueryOpsiDataObjectDataDetails getBody$() {
        return this.queryOpsiDataObjectDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).queryOpsiDataObjectDataDetails(this.queryOpsiDataObjectDataDetails).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",queryOpsiDataObjectDataDetails=").append(String.valueOf((Object)this.queryOpsiDataObjectDataDetails));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryOpsiDataObjectDataRequest)) {
            return false;
        }
        QueryOpsiDataObjectDataRequest other = (QueryOpsiDataObjectDataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.queryOpsiDataObjectDataDetails, (Object)other.queryOpsiDataObjectDataDetails) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.queryOpsiDataObjectDataDetails == null ? 43 : this.queryOpsiDataObjectDataDetails.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<QueryOpsiDataObjectDataRequest, QueryOpsiDataObjectDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private QueryOpsiDataObjectDataDetails queryOpsiDataObjectDataDetails = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder queryOpsiDataObjectDataDetails(QueryOpsiDataObjectDataDetails queryOpsiDataObjectDataDetails) {
            this.queryOpsiDataObjectDataDetails = queryOpsiDataObjectDataDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(QueryOpsiDataObjectDataRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.queryOpsiDataObjectDataDetails(o.getQueryOpsiDataObjectDataDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public QueryOpsiDataObjectDataRequest build() {
            QueryOpsiDataObjectDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(QueryOpsiDataObjectDataDetails body) {
            this.queryOpsiDataObjectDataDetails(body);
            return this;
        }

        public QueryOpsiDataObjectDataRequest buildWithoutInvocationCallback() {
            QueryOpsiDataObjectDataRequest request = new QueryOpsiDataObjectDataRequest();
            request.compartmentId = this.compartmentId;
            request.queryOpsiDataObjectDataDetails = this.queryOpsiDataObjectDataDetails;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

