/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeHostInsightResourceUsageTrendRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceMetric;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private List<PlatformType> platformType;
    private List<String> id;
    private List<String> exadataInsightId;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private List<String> definedTagEquals;
    private List<String> freeformTagEquals;
    private List<String> definedTagExists;
    private List<String> freeformTagExists;
    private Boolean compartmentIdInSubtree;
    private List<String> hostType;
    private String hostId;
    private List<String> vmclusterName;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceMetric() {
        return this.resourceMetric;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public List<PlatformType> getPlatformType() {
        return this.platformType;
    }

    public List<String> getId() {
        return this.id;
    }

    public List<String> getExadataInsightId() {
        return this.exadataInsightId;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getDefinedTagEquals() {
        return this.definedTagEquals;
    }

    public List<String> getFreeformTagEquals() {
        return this.freeformTagEquals;
    }

    public List<String> getDefinedTagExists() {
        return this.definedTagExists;
    }

    public List<String> getFreeformTagExists() {
        return this.freeformTagExists;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public List<String> getHostType() {
        return this.hostType;
    }

    public String getHostId() {
        return this.hostId;
    }

    public List<String> getVmclusterName() {
        return this.vmclusterName;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).resourceMetric(this.resourceMetric).analysisTimeInterval(this.analysisTimeInterval).timeIntervalStart(this.timeIntervalStart).timeIntervalEnd(this.timeIntervalEnd).platformType(this.platformType).id(this.id).exadataInsightId(this.exadataInsightId).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).definedTagEquals(this.definedTagEquals).freeformTagEquals(this.freeformTagEquals).definedTagExists(this.definedTagExists).freeformTagExists(this.freeformTagExists).compartmentIdInSubtree(this.compartmentIdInSubtree).hostType(this.hostType).hostId(this.hostId).vmclusterName(this.vmclusterName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",resourceMetric=").append(String.valueOf(this.resourceMetric));
        sb.append(",analysisTimeInterval=").append(String.valueOf(this.analysisTimeInterval));
        sb.append(",timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(",timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(",platformType=").append(String.valueOf(this.platformType));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",exadataInsightId=").append(String.valueOf(this.exadataInsightId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",definedTagEquals=").append(String.valueOf(this.definedTagEquals));
        sb.append(",freeformTagEquals=").append(String.valueOf(this.freeformTagEquals));
        sb.append(",definedTagExists=").append(String.valueOf(this.definedTagExists));
        sb.append(",freeformTagExists=").append(String.valueOf(this.freeformTagExists));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",hostType=").append(String.valueOf(this.hostType));
        sb.append(",hostId=").append(String.valueOf(this.hostId));
        sb.append(",vmclusterName=").append(String.valueOf(this.vmclusterName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeHostInsightResourceUsageTrendRequest)) {
            return false;
        }
        SummarizeHostInsightResourceUsageTrendRequest other = (SummarizeHostInsightResourceUsageTrendRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceMetric, other.resourceMetric) && Objects.equals(this.analysisTimeInterval, other.analysisTimeInterval) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.platformType, other.platformType) && Objects.equals(this.id, other.id) && Objects.equals(this.exadataInsightId, other.exadataInsightId) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.definedTagEquals, other.definedTagEquals) && Objects.equals(this.freeformTagEquals, other.freeformTagEquals) && Objects.equals(this.definedTagExists, other.definedTagExists) && Objects.equals(this.freeformTagExists, other.freeformTagExists) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.hostType, other.hostType) && Objects.equals(this.hostId, other.hostId) && Objects.equals(this.vmclusterName, other.vmclusterName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceMetric == null ? 43 : this.resourceMetric.hashCode());
        result = result * 59 + (this.analysisTimeInterval == null ? 43 : this.analysisTimeInterval.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.platformType == null ? 43 : this.platformType.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.exadataInsightId == null ? 43 : this.exadataInsightId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.definedTagEquals == null ? 43 : this.definedTagEquals.hashCode());
        result = result * 59 + (this.freeformTagEquals == null ? 43 : this.freeformTagEquals.hashCode());
        result = result * 59 + (this.definedTagExists == null ? 43 : this.definedTagExists.hashCode());
        result = result * 59 + (this.freeformTagExists == null ? 43 : this.freeformTagExists.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.hostType == null ? 43 : this.hostType.hashCode());
        result = result * 59 + (this.hostId == null ? 43 : this.hostId.hashCode());
        result = result * 59 + (this.vmclusterName == null ? 43 : this.vmclusterName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeHostInsightResourceUsageTrendRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String resourceMetric = null;
        private String analysisTimeInterval = null;
        private Date timeIntervalStart = null;
        private Date timeIntervalEnd = null;
        private List<PlatformType> platformType = null;
        private List<String> id = null;
        private List<String> exadataInsightId = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private List<String> definedTagEquals = null;
        private List<String> freeformTagEquals = null;
        private List<String> definedTagExists = null;
        private List<String> freeformTagExists = null;
        private Boolean compartmentIdInSubtree = null;
        private List<String> hostType = null;
        private String hostId = null;
        private List<String> vmclusterName = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceMetric(String resourceMetric) {
            this.resourceMetric = resourceMetric;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder platformType(List<PlatformType> platformType) {
            this.platformType = platformType;
            return this;
        }

        public Builder platformType(PlatformType singularValue) {
            return this.platformType(Arrays.asList(singularValue));
        }

        public Builder id(List<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String singularValue) {
            return this.id(Arrays.asList(singularValue));
        }

        public Builder exadataInsightId(List<String> exadataInsightId) {
            this.exadataInsightId = exadataInsightId;
            return this;
        }

        public Builder exadataInsightId(String singularValue) {
            return this.exadataInsightId(Arrays.asList(singularValue));
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder definedTagEquals(List<String> definedTagEquals) {
            this.definedTagEquals = definedTagEquals;
            return this;
        }

        public Builder definedTagEquals(String singularValue) {
            return this.definedTagEquals(Arrays.asList(singularValue));
        }

        public Builder freeformTagEquals(List<String> freeformTagEquals) {
            this.freeformTagEquals = freeformTagEquals;
            return this;
        }

        public Builder freeformTagEquals(String singularValue) {
            return this.freeformTagEquals(Arrays.asList(singularValue));
        }

        public Builder definedTagExists(List<String> definedTagExists) {
            this.definedTagExists = definedTagExists;
            return this;
        }

        public Builder definedTagExists(String singularValue) {
            return this.definedTagExists(Arrays.asList(singularValue));
        }

        public Builder freeformTagExists(List<String> freeformTagExists) {
            this.freeformTagExists = freeformTagExists;
            return this;
        }

        public Builder freeformTagExists(String singularValue) {
            return this.freeformTagExists(Arrays.asList(singularValue));
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder hostType(List<String> hostType) {
            this.hostType = hostType;
            return this;
        }

        public Builder hostType(String singularValue) {
            return this.hostType(Arrays.asList(singularValue));
        }

        public Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public Builder vmclusterName(List<String> vmclusterName) {
            this.vmclusterName = vmclusterName;
            return this;
        }

        public Builder vmclusterName(String singularValue) {
            return this.vmclusterName(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeHostInsightResourceUsageTrendRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceMetric(o.getResourceMetric());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.platformType(o.getPlatformType());
            this.id(o.getId());
            this.exadataInsightId(o.getExadataInsightId());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.definedTagEquals(o.getDefinedTagEquals());
            this.freeformTagEquals(o.getFreeformTagEquals());
            this.definedTagExists(o.getDefinedTagExists());
            this.freeformTagExists(o.getFreeformTagExists());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.hostType(o.getHostType());
            this.hostId(o.getHostId());
            this.vmclusterName(o.getVmclusterName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeHostInsightResourceUsageTrendRequest build() {
            SummarizeHostInsightResourceUsageTrendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeHostInsightResourceUsageTrendRequest buildWithoutInvocationCallback() {
            SummarizeHostInsightResourceUsageTrendRequest request = new SummarizeHostInsightResourceUsageTrendRequest();
            request.compartmentId = this.compartmentId;
            request.resourceMetric = this.resourceMetric;
            request.analysisTimeInterval = this.analysisTimeInterval;
            request.timeIntervalStart = this.timeIntervalStart;
            request.timeIntervalEnd = this.timeIntervalEnd;
            request.platformType = this.platformType;
            request.id = this.id;
            request.exadataInsightId = this.exadataInsightId;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.definedTagEquals = this.definedTagEquals;
            request.freeformTagEquals = this.freeformTagEquals;
            request.definedTagExists = this.definedTagExists;
            request.freeformTagExists = this.freeformTagExists;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.hostType = this.hostType;
            request.hostId = this.hostId;
            request.vmclusterName = this.vmclusterName;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        EndTimestamp("endTimestamp"),
        Usage("usage"),
        Capacity("capacity");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PlatformType implements BmcEnum
    {
        Linux("LINUX"),
        Solaris("SOLARIS"),
        Sunos("SUNOS"),
        Zlinux("ZLINUX"),
        Windows("WINDOWS"),
        Aix("AIX"),
        HpUx("HP_UX");

        private final String value;
        private static Map<String, PlatformType> map;

        private PlatformType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PlatformType: " + key);
        }

        static {
            map = new HashMap<String, PlatformType>();
            for (PlatformType v : PlatformType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

