/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeSqlStatisticsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<DatabaseType> databaseType;
    private List<String> databaseId;
    private List<String> id;
    private List<String> exadataInsightId;
    private List<String> cdbName;
    private List<String> hostName;
    private Double databaseTimePctGreaterThan;
    private List<String> sqlIdentifier;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private List<Category> category;
    private List<String> definedTagEquals;
    private List<String> freeformTagEquals;
    private List<String> definedTagExists;
    private List<String> freeformTagExists;
    private Boolean compartmentIdInSubtree;
    private List<String> vmclusterName;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<DatabaseType> getDatabaseType() {
        return this.databaseType;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public List<String> getId() {
        return this.id;
    }

    public List<String> getExadataInsightId() {
        return this.exadataInsightId;
    }

    public List<String> getCdbName() {
        return this.cdbName;
    }

    public List<String> getHostName() {
        return this.hostName;
    }

    public Double getDatabaseTimePctGreaterThan() {
        return this.databaseTimePctGreaterThan;
    }

    public List<String> getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<Category> getCategory() {
        return this.category;
    }

    public List<String> getDefinedTagEquals() {
        return this.definedTagEquals;
    }

    public List<String> getFreeformTagEquals() {
        return this.freeformTagEquals;
    }

    public List<String> getDefinedTagExists() {
        return this.definedTagExists;
    }

    public List<String> getFreeformTagExists() {
        return this.freeformTagExists;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public List<String> getVmclusterName() {
        return this.vmclusterName;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).databaseType(this.databaseType).databaseId(this.databaseId).id(this.id).exadataInsightId(this.exadataInsightId).cdbName(this.cdbName).hostName(this.hostName).databaseTimePctGreaterThan(this.databaseTimePctGreaterThan).sqlIdentifier(this.sqlIdentifier).analysisTimeInterval(this.analysisTimeInterval).timeIntervalStart(this.timeIntervalStart).timeIntervalEnd(this.timeIntervalEnd).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).sortOrder(this.sortOrder).sortBy(this.sortBy).category(this.category).definedTagEquals(this.definedTagEquals).freeformTagEquals(this.freeformTagEquals).definedTagExists(this.definedTagExists).freeformTagExists(this.freeformTagExists).compartmentIdInSubtree(this.compartmentIdInSubtree).vmclusterName(this.vmclusterName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",databaseType=").append(String.valueOf(this.databaseType));
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",exadataInsightId=").append(String.valueOf(this.exadataInsightId));
        sb.append(",cdbName=").append(String.valueOf(this.cdbName));
        sb.append(",hostName=").append(String.valueOf(this.hostName));
        sb.append(",databaseTimePctGreaterThan=").append(String.valueOf(this.databaseTimePctGreaterThan));
        sb.append(",sqlIdentifier=").append(String.valueOf(this.sqlIdentifier));
        sb.append(",analysisTimeInterval=").append(String.valueOf(this.analysisTimeInterval));
        sb.append(",timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(",timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",category=").append(String.valueOf(this.category));
        sb.append(",definedTagEquals=").append(String.valueOf(this.definedTagEquals));
        sb.append(",freeformTagEquals=").append(String.valueOf(this.freeformTagEquals));
        sb.append(",definedTagExists=").append(String.valueOf(this.definedTagExists));
        sb.append(",freeformTagExists=").append(String.valueOf(this.freeformTagExists));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",vmclusterName=").append(String.valueOf(this.vmclusterName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeSqlStatisticsRequest)) {
            return false;
        }
        SummarizeSqlStatisticsRequest other = (SummarizeSqlStatisticsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.databaseType, other.databaseType) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.id, other.id) && Objects.equals(this.exadataInsightId, other.exadataInsightId) && Objects.equals(this.cdbName, other.cdbName) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.databaseTimePctGreaterThan, other.databaseTimePctGreaterThan) && Objects.equals(this.sqlIdentifier, other.sqlIdentifier) && Objects.equals(this.analysisTimeInterval, other.analysisTimeInterval) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.category, other.category) && Objects.equals(this.definedTagEquals, other.definedTagEquals) && Objects.equals(this.freeformTagEquals, other.freeformTagEquals) && Objects.equals(this.definedTagExists, other.definedTagExists) && Objects.equals(this.freeformTagExists, other.freeformTagExists) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.vmclusterName, other.vmclusterName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.exadataInsightId == null ? 43 : this.exadataInsightId.hashCode());
        result = result * 59 + (this.cdbName == null ? 43 : this.cdbName.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.databaseTimePctGreaterThan == null ? 43 : this.databaseTimePctGreaterThan.hashCode());
        result = result * 59 + (this.sqlIdentifier == null ? 43 : this.sqlIdentifier.hashCode());
        result = result * 59 + (this.analysisTimeInterval == null ? 43 : this.analysisTimeInterval.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.definedTagEquals == null ? 43 : this.definedTagEquals.hashCode());
        result = result * 59 + (this.freeformTagEquals == null ? 43 : this.freeformTagEquals.hashCode());
        result = result * 59 + (this.definedTagExists == null ? 43 : this.definedTagExists.hashCode());
        result = result * 59 + (this.freeformTagExists == null ? 43 : this.freeformTagExists.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.vmclusterName == null ? 43 : this.vmclusterName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeSqlStatisticsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<DatabaseType> databaseType = null;
        private List<String> databaseId = null;
        private List<String> id = null;
        private List<String> exadataInsightId = null;
        private List<String> cdbName = null;
        private List<String> hostName = null;
        private Double databaseTimePctGreaterThan = null;
        private List<String> sqlIdentifier = null;
        private String analysisTimeInterval = null;
        private Date timeIntervalStart = null;
        private Date timeIntervalEnd = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private List<Category> category = null;
        private List<String> definedTagEquals = null;
        private List<String> freeformTagEquals = null;
        private List<String> definedTagExists = null;
        private List<String> freeformTagExists = null;
        private Boolean compartmentIdInSubtree = null;
        private List<String> vmclusterName = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder databaseType(List<DatabaseType> databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder databaseType(DatabaseType singularValue) {
            return this.databaseType(Arrays.asList(singularValue));
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder databaseId(String singularValue) {
            return this.databaseId(Arrays.asList(singularValue));
        }

        public Builder id(List<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String singularValue) {
            return this.id(Arrays.asList(singularValue));
        }

        public Builder exadataInsightId(List<String> exadataInsightId) {
            this.exadataInsightId = exadataInsightId;
            return this;
        }

        public Builder exadataInsightId(String singularValue) {
            return this.exadataInsightId(Arrays.asList(singularValue));
        }

        public Builder cdbName(List<String> cdbName) {
            this.cdbName = cdbName;
            return this;
        }

        public Builder cdbName(String singularValue) {
            return this.cdbName(Arrays.asList(singularValue));
        }

        public Builder hostName(List<String> hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder hostName(String singularValue) {
            return this.hostName(Arrays.asList(singularValue));
        }

        public Builder databaseTimePctGreaterThan(Double databaseTimePctGreaterThan) {
            this.databaseTimePctGreaterThan = databaseTimePctGreaterThan;
            return this;
        }

        public Builder sqlIdentifier(List<String> sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            return this;
        }

        public Builder sqlIdentifier(String singularValue) {
            return this.sqlIdentifier(Arrays.asList(singularValue));
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder category(List<Category> category) {
            this.category = category;
            return this;
        }

        public Builder category(Category singularValue) {
            return this.category(Arrays.asList(singularValue));
        }

        public Builder definedTagEquals(List<String> definedTagEquals) {
            this.definedTagEquals = definedTagEquals;
            return this;
        }

        public Builder definedTagEquals(String singularValue) {
            return this.definedTagEquals(Arrays.asList(singularValue));
        }

        public Builder freeformTagEquals(List<String> freeformTagEquals) {
            this.freeformTagEquals = freeformTagEquals;
            return this;
        }

        public Builder freeformTagEquals(String singularValue) {
            return this.freeformTagEquals(Arrays.asList(singularValue));
        }

        public Builder definedTagExists(List<String> definedTagExists) {
            this.definedTagExists = definedTagExists;
            return this;
        }

        public Builder definedTagExists(String singularValue) {
            return this.definedTagExists(Arrays.asList(singularValue));
        }

        public Builder freeformTagExists(List<String> freeformTagExists) {
            this.freeformTagExists = freeformTagExists;
            return this;
        }

        public Builder freeformTagExists(String singularValue) {
            return this.freeformTagExists(Arrays.asList(singularValue));
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder vmclusterName(List<String> vmclusterName) {
            this.vmclusterName = vmclusterName;
            return this;
        }

        public Builder vmclusterName(String singularValue) {
            return this.vmclusterName(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeSqlStatisticsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.databaseType(o.getDatabaseType());
            this.databaseId(o.getDatabaseId());
            this.id(o.getId());
            this.exadataInsightId(o.getExadataInsightId());
            this.cdbName(o.getCdbName());
            this.hostName(o.getHostName());
            this.databaseTimePctGreaterThan(o.getDatabaseTimePctGreaterThan());
            this.sqlIdentifier(o.getSqlIdentifier());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.category(o.getCategory());
            this.definedTagEquals(o.getDefinedTagEquals());
            this.freeformTagEquals(o.getFreeformTagEquals());
            this.definedTagExists(o.getDefinedTagExists());
            this.freeformTagExists(o.getFreeformTagExists());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.vmclusterName(o.getVmclusterName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeSqlStatisticsRequest build() {
            SummarizeSqlStatisticsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeSqlStatisticsRequest buildWithoutInvocationCallback() {
            SummarizeSqlStatisticsRequest request = new SummarizeSqlStatisticsRequest();
            request.compartmentId = this.compartmentId;
            request.databaseType = this.databaseType;
            request.databaseId = this.databaseId;
            request.id = this.id;
            request.exadataInsightId = this.exadataInsightId;
            request.cdbName = this.cdbName;
            request.hostName = this.hostName;
            request.databaseTimePctGreaterThan = this.databaseTimePctGreaterThan;
            request.sqlIdentifier = this.sqlIdentifier;
            request.analysisTimeInterval = this.analysisTimeInterval;
            request.timeIntervalStart = this.timeIntervalStart;
            request.timeIntervalEnd = this.timeIntervalEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.category = this.category;
            request.definedTagEquals = this.definedTagEquals;
            request.freeformTagEquals = this.freeformTagEquals;
            request.definedTagExists = this.definedTagExists;
            request.freeformTagExists = this.freeformTagExists;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.vmclusterName = this.vmclusterName;
            return request;
        }
    }

    public static enum Category implements BmcEnum
    {
        Degrading("DEGRADING"),
        Variant("VARIANT"),
        Inefficient("INEFFICIENT"),
        ChangingPlans("CHANGING_PLANS"),
        Improving("IMPROVING"),
        DegradingVariant("DEGRADING_VARIANT"),
        DegradingInefficient("DEGRADING_INEFFICIENT"),
        DegradingChangingPlans("DEGRADING_CHANGING_PLANS"),
        DegradingIncreasingIo("DEGRADING_INCREASING_IO"),
        DegradingIncreasingCpu("DEGRADING_INCREASING_CPU"),
        DegradingIncreasingInefficientWait("DEGRADING_INCREASING_INEFFICIENT_WAIT"),
        DegradingChangingPlansAndIncreasingIo("DEGRADING_CHANGING_PLANS_AND_INCREASING_IO"),
        DegradingChangingPlansAndIncreasingCpu("DEGRADING_CHANGING_PLANS_AND_INCREASING_CPU"),
        DegradingChangingPlansAndIncreasingInefficientWait("DEGRADING_CHANGING_PLANS_AND_INCREASING_INEFFICIENT_WAIT"),
        VariantInefficient("VARIANT_INEFFICIENT"),
        VariantChangingPlans("VARIANT_CHANGING_PLANS"),
        VariantIncreasingIo("VARIANT_INCREASING_IO"),
        VariantIncreasingCpu("VARIANT_INCREASING_CPU"),
        VariantIncreasingInefficientWait("VARIANT_INCREASING_INEFFICIENT_WAIT"),
        VariantChangingPlansAndIncreasingIo("VARIANT_CHANGING_PLANS_AND_INCREASING_IO"),
        VariantChangingPlansAndIncreasingCpu("VARIANT_CHANGING_PLANS_AND_INCREASING_CPU"),
        VariantChangingPlansAndIncreasingInefficientWait("VARIANT_CHANGING_PLANS_AND_INCREASING_INEFFICIENT_WAIT"),
        InefficientChangingPlans("INEFFICIENT_CHANGING_PLANS"),
        InefficientIncreasingInefficientWait("INEFFICIENT_INCREASING_INEFFICIENT_WAIT"),
        InefficientChangingPlansAndIncreasingInefficientWait("INEFFICIENT_CHANGING_PLANS_AND_INCREASING_INEFFICIENT_WAIT");

        private final String value;
        private static Map<String, Category> map;

        private Category(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Category create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Category: " + key);
        }

        static {
            map = new HashMap<String, Category>();
            for (Category v : Category.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DatabaseTimeInSec("databaseTimeInSec"),
        ExecutionsPerHour("executionsPerHour"),
        ExecutionsCount("executionsCount"),
        CpuTimeInSec("cpuTimeInSec"),
        IoTimeInSec("ioTimeInSec"),
        InefficientWaitTimeInSec("inefficientWaitTimeInSec"),
        ResponseTimeInSec("responseTimeInSec"),
        PlanCount("planCount"),
        Variability("variability"),
        AverageActiveSessions("averageActiveSessions"),
        DatabaseTimePct("databaseTimePct"),
        InefficiencyInPct("inefficiencyInPct"),
        ChangeInCpuTimeInPct("changeInCpuTimeInPct"),
        ChangeInIoTimeInPct("changeInIoTimeInPct"),
        ChangeInInefficientWaitTimeInPct("changeInInefficientWaitTimeInPct"),
        ChangeInResponseTimeInPct("changeInResponseTimeInPct"),
        ChangeInAverageActiveSessionsInPct("changeInAverageActiveSessionsInPct"),
        ChangeInExecutionsPerHourInPct("changeInExecutionsPerHourInPct"),
        ChangeInInefficiencyInPct("changeInInefficiencyInPct");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseType implements BmcEnum
    {
        AdwS("ADW-S"),
        AtpS("ATP-S"),
        AdwD("ADW-D"),
        AtpD("ATP-D"),
        ExternalPdb("EXTERNAL-PDB"),
        ExternalNoncdb("EXTERNAL-NONCDB"),
        ComanagedVmCdb("COMANAGED-VM-CDB"),
        ComanagedVmPdb("COMANAGED-VM-PDB"),
        ComanagedVmNoncdb("COMANAGED-VM-NONCDB"),
        ComanagedBmCdb("COMANAGED-BM-CDB"),
        ComanagedBmPdb("COMANAGED-BM-PDB"),
        ComanagedBmNoncdb("COMANAGED-BM-NONCDB"),
        ComanagedExacsCdb("COMANAGED-EXACS-CDB"),
        ComanagedExacsPdb("COMANAGED-EXACS-PDB"),
        ComanagedExacsNoncdb("COMANAGED-EXACS-NONCDB");

        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseType: " + key);
        }

        static {
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

