/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.ConnectionDetails;
import com.oracle.bmc.opsi.model.CreateDatabaseInsightDetails;
import com.oracle.bmc.opsi.model.CredentialDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entitySource")
@JsonFilter(value="explicitlySetFilter")
public final class CreateAutonomousDatabaseInsightDetails
extends CreateDatabaseInsightDetails {
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="databaseResourceType")
    private final String databaseResourceType;
    @JsonProperty(value="isAdvancedFeaturesEnabled")
    private final Boolean isAdvancedFeaturesEnabled;
    @JsonProperty(value="connectionDetails")
    private final ConnectionDetails connectionDetails;
    @JsonProperty(value="credentialDetails")
    private final CredentialDetails credentialDetails;
    @JsonProperty(value="opsiPrivateEndpointId")
    private final String opsiPrivateEndpointId;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateAutonomousDatabaseInsightDetails(String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String databaseId, String databaseResourceType, Boolean isAdvancedFeaturesEnabled, ConnectionDetails connectionDetails, CredentialDetails credentialDetails, String opsiPrivateEndpointId, Map<String, Map<String, Object>> systemTags) {
        super(compartmentId, freeformTags, definedTags);
        this.databaseId = databaseId;
        this.databaseResourceType = databaseResourceType;
        this.isAdvancedFeaturesEnabled = isAdvancedFeaturesEnabled;
        this.connectionDetails = connectionDetails;
        this.credentialDetails = credentialDetails;
        this.opsiPrivateEndpointId = opsiPrivateEndpointId;
        this.systemTags = systemTags;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDatabaseResourceType() {
        return this.databaseResourceType;
    }

    public Boolean getIsAdvancedFeaturesEnabled() {
        return this.isAdvancedFeaturesEnabled;
    }

    public ConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    public CredentialDetails getCredentialDetails() {
        return this.credentialDetails;
    }

    public String getOpsiPrivateEndpointId() {
        return this.opsiPrivateEndpointId;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateAutonomousDatabaseInsightDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", databaseResourceType=").append(String.valueOf(this.databaseResourceType));
        sb.append(", isAdvancedFeaturesEnabled=").append(String.valueOf(this.isAdvancedFeaturesEnabled));
        sb.append(", connectionDetails=").append(String.valueOf((Object)this.connectionDetails));
        sb.append(", credentialDetails=").append(String.valueOf((Object)this.credentialDetails));
        sb.append(", opsiPrivateEndpointId=").append(String.valueOf(this.opsiPrivateEndpointId));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAutonomousDatabaseInsightDetails)) {
            return false;
        }
        CreateAutonomousDatabaseInsightDetails other = (CreateAutonomousDatabaseInsightDetails)((Object)o);
        return Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.databaseResourceType, other.databaseResourceType) && Objects.equals(this.isAdvancedFeaturesEnabled, other.isAdvancedFeaturesEnabled) && Objects.equals((Object)this.connectionDetails, (Object)other.connectionDetails) && Objects.equals((Object)this.credentialDetails, (Object)other.credentialDetails) && Objects.equals(this.opsiPrivateEndpointId, other.opsiPrivateEndpointId) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.databaseResourceType == null ? 43 : this.databaseResourceType.hashCode());
        result = result * 59 + (this.isAdvancedFeaturesEnabled == null ? 43 : this.isAdvancedFeaturesEnabled.hashCode());
        result = result * 59 + (this.connectionDetails == null ? 43 : this.connectionDetails.hashCode());
        result = result * 59 + (this.credentialDetails == null ? 43 : this.credentialDetails.hashCode());
        result = result * 59 + (this.opsiPrivateEndpointId == null ? 43 : this.opsiPrivateEndpointId.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="databaseResourceType")
        private String databaseResourceType;
        @JsonProperty(value="isAdvancedFeaturesEnabled")
        private Boolean isAdvancedFeaturesEnabled;
        @JsonProperty(value="connectionDetails")
        private ConnectionDetails connectionDetails;
        @JsonProperty(value="credentialDetails")
        private CredentialDetails credentialDetails;
        @JsonProperty(value="opsiPrivateEndpointId")
        private String opsiPrivateEndpointId;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder databaseResourceType(String databaseResourceType) {
            this.databaseResourceType = databaseResourceType;
            this.__explicitlySet__.add("databaseResourceType");
            return this;
        }

        public Builder isAdvancedFeaturesEnabled(Boolean isAdvancedFeaturesEnabled) {
            this.isAdvancedFeaturesEnabled = isAdvancedFeaturesEnabled;
            this.__explicitlySet__.add("isAdvancedFeaturesEnabled");
            return this;
        }

        public Builder connectionDetails(ConnectionDetails connectionDetails) {
            this.connectionDetails = connectionDetails;
            this.__explicitlySet__.add("connectionDetails");
            return this;
        }

        public Builder credentialDetails(CredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            this.__explicitlySet__.add("credentialDetails");
            return this;
        }

        public Builder opsiPrivateEndpointId(String opsiPrivateEndpointId) {
            this.opsiPrivateEndpointId = opsiPrivateEndpointId;
            this.__explicitlySet__.add("opsiPrivateEndpointId");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public CreateAutonomousDatabaseInsightDetails build() {
            CreateAutonomousDatabaseInsightDetails model = new CreateAutonomousDatabaseInsightDetails(this.compartmentId, this.freeformTags, this.definedTags, this.databaseId, this.databaseResourceType, this.isAdvancedFeaturesEnabled, this.connectionDetails, this.credentialDetails, this.opsiPrivateEndpointId, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateAutonomousDatabaseInsightDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("databaseResourceType")) {
                this.databaseResourceType(model.getDatabaseResourceType());
            }
            if (model.wasPropertyExplicitlySet("isAdvancedFeaturesEnabled")) {
                this.isAdvancedFeaturesEnabled(model.getIsAdvancedFeaturesEnabled());
            }
            if (model.wasPropertyExplicitlySet("connectionDetails")) {
                this.connectionDetails(model.getConnectionDetails());
            }
            if (model.wasPropertyExplicitlySet("credentialDetails")) {
                this.credentialDetails(model.getCredentialDetails());
            }
            if (model.wasPropertyExplicitlySet("opsiPrivateEndpointId")) {
                this.opsiPrivateEndpointId(model.getOpsiPrivateEndpointId());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

