/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.ConnectionDetails;
import com.oracle.bmc.opsi.model.CreateDatabaseInsightDetails;
import com.oracle.bmc.opsi.model.CredentialDetails;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entitySource")
@JsonFilter(value="explicitlySetFilter")
public final class CreateMacsManagedCloudDatabaseInsightDetails
extends CreateDatabaseInsightDetails {
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="managementAgentId")
    private final String managementAgentId;
    @JsonProperty(value="connectionDetails")
    private final ConnectionDetails connectionDetails;
    @JsonProperty(value="connectionCredentialDetails")
    private final CredentialDetails connectionCredentialDetails;
    @JsonProperty(value="databaseResourceType")
    private final String databaseResourceType;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateMacsManagedCloudDatabaseInsightDetails(String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String databaseId, String managementAgentId, ConnectionDetails connectionDetails, CredentialDetails connectionCredentialDetails, String databaseResourceType, DeploymentType deploymentType, Map<String, Map<String, Object>> systemTags) {
        super(compartmentId, freeformTags, definedTags);
        this.databaseId = databaseId;
        this.managementAgentId = managementAgentId;
        this.connectionDetails = connectionDetails;
        this.connectionCredentialDetails = connectionCredentialDetails;
        this.databaseResourceType = databaseResourceType;
        this.deploymentType = deploymentType;
        this.systemTags = systemTags;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getManagementAgentId() {
        return this.managementAgentId;
    }

    public ConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    public CredentialDetails getConnectionCredentialDetails() {
        return this.connectionCredentialDetails;
    }

    public String getDatabaseResourceType() {
        return this.databaseResourceType;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateMacsManagedCloudDatabaseInsightDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", managementAgentId=").append(String.valueOf(this.managementAgentId));
        sb.append(", connectionDetails=").append(String.valueOf((Object)this.connectionDetails));
        sb.append(", connectionCredentialDetails=").append(String.valueOf((Object)this.connectionCredentialDetails));
        sb.append(", databaseResourceType=").append(String.valueOf(this.databaseResourceType));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMacsManagedCloudDatabaseInsightDetails)) {
            return false;
        }
        CreateMacsManagedCloudDatabaseInsightDetails other = (CreateMacsManagedCloudDatabaseInsightDetails)((Object)o);
        return Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.managementAgentId, other.managementAgentId) && Objects.equals((Object)this.connectionDetails, (Object)other.connectionDetails) && Objects.equals((Object)this.connectionCredentialDetails, (Object)other.connectionCredentialDetails) && Objects.equals(this.databaseResourceType, other.databaseResourceType) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.managementAgentId == null ? 43 : this.managementAgentId.hashCode());
        result = result * 59 + (this.connectionDetails == null ? 43 : this.connectionDetails.hashCode());
        result = result * 59 + (this.connectionCredentialDetails == null ? 43 : this.connectionCredentialDetails.hashCode());
        result = result * 59 + (this.databaseResourceType == null ? 43 : this.databaseResourceType.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        return result;
    }

    public static enum DeploymentType implements BmcEnum
    {
        VirtualMachine("VIRTUAL_MACHINE"),
        BareMetal("BARE_METAL"),
        Exacc("EXACC"),
        Exacs("EXACS");

        private final String value;
        private static Map<String, DeploymentType> map;

        private DeploymentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DeploymentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DeploymentType: " + key);
        }

        static {
            map = new HashMap<String, DeploymentType>();
            for (DeploymentType v : DeploymentType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="managementAgentId")
        private String managementAgentId;
        @JsonProperty(value="connectionDetails")
        private ConnectionDetails connectionDetails;
        @JsonProperty(value="connectionCredentialDetails")
        private CredentialDetails connectionCredentialDetails;
        @JsonProperty(value="databaseResourceType")
        private String databaseResourceType;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder managementAgentId(String managementAgentId) {
            this.managementAgentId = managementAgentId;
            this.__explicitlySet__.add("managementAgentId");
            return this;
        }

        public Builder connectionDetails(ConnectionDetails connectionDetails) {
            this.connectionDetails = connectionDetails;
            this.__explicitlySet__.add("connectionDetails");
            return this;
        }

        public Builder connectionCredentialDetails(CredentialDetails connectionCredentialDetails) {
            this.connectionCredentialDetails = connectionCredentialDetails;
            this.__explicitlySet__.add("connectionCredentialDetails");
            return this;
        }

        public Builder databaseResourceType(String databaseResourceType) {
            this.databaseResourceType = databaseResourceType;
            this.__explicitlySet__.add("databaseResourceType");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public CreateMacsManagedCloudDatabaseInsightDetails build() {
            CreateMacsManagedCloudDatabaseInsightDetails model = new CreateMacsManagedCloudDatabaseInsightDetails(this.compartmentId, this.freeformTags, this.definedTags, this.databaseId, this.managementAgentId, this.connectionDetails, this.connectionCredentialDetails, this.databaseResourceType, this.deploymentType, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateMacsManagedCloudDatabaseInsightDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("managementAgentId")) {
                this.managementAgentId(model.getManagementAgentId());
            }
            if (model.wasPropertyExplicitlySet("connectionDetails")) {
                this.connectionDetails(model.getConnectionDetails());
            }
            if (model.wasPropertyExplicitlySet("connectionCredentialDetails")) {
                this.connectionCredentialDetails(model.getConnectionCredentialDetails());
            }
            if (model.wasPropertyExplicitlySet("databaseResourceType")) {
                this.databaseResourceType(model.getDatabaseResourceType());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

