/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class ExadataAsmEntity
extends DatabaseConfigurationMetricGroup {
    @JsonProperty(value="instanceName")
    private final String instanceName;
    @JsonProperty(value="clusterName")
    private final String clusterName;
    @JsonProperty(value="softwareVersion")
    private final String softwareVersion;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExadataAsmEntity(Date timeCollected, String instanceName, String clusterName, String softwareVersion) {
        super(timeCollected);
        this.instanceName = instanceName;
        this.clusterName = clusterName;
        this.softwareVersion = softwareVersion;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExadataAsmEntity(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", instanceName=").append(String.valueOf(this.instanceName));
        sb.append(", clusterName=").append(String.valueOf(this.clusterName));
        sb.append(", softwareVersion=").append(String.valueOf(this.softwareVersion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExadataAsmEntity)) {
            return false;
        }
        ExadataAsmEntity other = (ExadataAsmEntity)((Object)o);
        return Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.softwareVersion, other.softwareVersion) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + (this.clusterName == null ? 43 : this.clusterName.hashCode());
        result = result * 59 + (this.softwareVersion == null ? 43 : this.softwareVersion.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="clusterName")
        private String clusterName;
        @JsonProperty(value="softwareVersion")
        private String softwareVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            this.__explicitlySet__.add("clusterName");
            return this;
        }

        public Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            this.__explicitlySet__.add("softwareVersion");
            return this;
        }

        public ExadataAsmEntity build() {
            ExadataAsmEntity model = new ExadataAsmEntity(this.timeCollected, this.instanceName, this.clusterName, this.softwareVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExadataAsmEntity model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            if (model.wasPropertyExplicitlySet("clusterName")) {
                this.clusterName(model.getClusterName());
            }
            if (model.wasPropertyExplicitlySet("softwareVersion")) {
                this.softwareVersion(model.getSoftwareVersion());
            }
            return this;
        }
    }
}

