/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class ExadataCellConfig
extends DatabaseConfigurationMetricGroup {
    @JsonProperty(value="cellName")
    private final String cellName;
    @JsonProperty(value="cellHash")
    private final String cellHash;
    @JsonProperty(value="cellProperties")
    private final String cellProperties;
    @JsonProperty(value="cellConfigs")
    private final String cellConfigs;
    @JsonProperty(value="diskCounts")
    private final String diskCounts;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExadataCellConfig(Date timeCollected, String cellName, String cellHash, String cellProperties, String cellConfigs, String diskCounts) {
        super(timeCollected);
        this.cellName = cellName;
        this.cellHash = cellHash;
        this.cellProperties = cellProperties;
        this.cellConfigs = cellConfigs;
        this.diskCounts = diskCounts;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getCellHash() {
        return this.cellHash;
    }

    public String getCellProperties() {
        return this.cellProperties;
    }

    public String getCellConfigs() {
        return this.cellConfigs;
    }

    public String getDiskCounts() {
        return this.diskCounts;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExadataCellConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", cellName=").append(String.valueOf(this.cellName));
        sb.append(", cellHash=").append(String.valueOf(this.cellHash));
        sb.append(", cellProperties=").append(String.valueOf(this.cellProperties));
        sb.append(", cellConfigs=").append(String.valueOf(this.cellConfigs));
        sb.append(", diskCounts=").append(String.valueOf(this.diskCounts));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExadataCellConfig)) {
            return false;
        }
        ExadataCellConfig other = (ExadataCellConfig)((Object)o);
        return Objects.equals(this.cellName, other.cellName) && Objects.equals(this.cellHash, other.cellHash) && Objects.equals(this.cellProperties, other.cellProperties) && Objects.equals(this.cellConfigs, other.cellConfigs) && Objects.equals(this.diskCounts, other.diskCounts) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cellName == null ? 43 : this.cellName.hashCode());
        result = result * 59 + (this.cellHash == null ? 43 : this.cellHash.hashCode());
        result = result * 59 + (this.cellProperties == null ? 43 : this.cellProperties.hashCode());
        result = result * 59 + (this.cellConfigs == null ? 43 : this.cellConfigs.hashCode());
        result = result * 59 + (this.diskCounts == null ? 43 : this.diskCounts.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="cellName")
        private String cellName;
        @JsonProperty(value="cellHash")
        private String cellHash;
        @JsonProperty(value="cellProperties")
        private String cellProperties;
        @JsonProperty(value="cellConfigs")
        private String cellConfigs;
        @JsonProperty(value="diskCounts")
        private String diskCounts;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder cellName(String cellName) {
            this.cellName = cellName;
            this.__explicitlySet__.add("cellName");
            return this;
        }

        public Builder cellHash(String cellHash) {
            this.cellHash = cellHash;
            this.__explicitlySet__.add("cellHash");
            return this;
        }

        public Builder cellProperties(String cellProperties) {
            this.cellProperties = cellProperties;
            this.__explicitlySet__.add("cellProperties");
            return this;
        }

        public Builder cellConfigs(String cellConfigs) {
            this.cellConfigs = cellConfigs;
            this.__explicitlySet__.add("cellConfigs");
            return this;
        }

        public Builder diskCounts(String diskCounts) {
            this.diskCounts = diskCounts;
            this.__explicitlySet__.add("diskCounts");
            return this;
        }

        public ExadataCellConfig build() {
            ExadataCellConfig model = new ExadataCellConfig(this.timeCollected, this.cellName, this.cellHash, this.cellProperties, this.cellConfigs, this.diskCounts);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExadataCellConfig model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("cellName")) {
                this.cellName(model.getCellName());
            }
            if (model.wasPropertyExplicitlySet("cellHash")) {
                this.cellHash(model.getCellHash());
            }
            if (model.wasPropertyExplicitlySet("cellProperties")) {
                this.cellProperties(model.getCellProperties());
            }
            if (model.wasPropertyExplicitlySet("cellConfigs")) {
                this.cellConfigs(model.getCellConfigs());
            }
            if (model.wasPropertyExplicitlySet("diskCounts")) {
                this.diskCounts(model.getDiskCounts());
            }
            return this;
        }
    }
}

