/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.InstanceMetrics;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExadataInsightResourceStatistics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="usage")
    private final Double usage;
    @JsonProperty(value="capacity")
    private final Double capacity;
    @JsonProperty(value="totalHostCapacity")
    private final Double totalHostCapacity;
    @JsonProperty(value="utilizationPercent")
    private final Double utilizationPercent;
    @JsonProperty(value="usageChangePercent")
    private final Double usageChangePercent;
    @JsonProperty(value="instanceMetrics")
    private final List<InstanceMetrics> instanceMetrics;

    @Deprecated
    @ConstructorProperties(value={"usage", "capacity", "totalHostCapacity", "utilizationPercent", "usageChangePercent", "instanceMetrics"})
    public ExadataInsightResourceStatistics(Double usage, Double capacity, Double totalHostCapacity, Double utilizationPercent, Double usageChangePercent, List<InstanceMetrics> instanceMetrics) {
        this.usage = usage;
        this.capacity = capacity;
        this.totalHostCapacity = totalHostCapacity;
        this.utilizationPercent = utilizationPercent;
        this.usageChangePercent = usageChangePercent;
        this.instanceMetrics = instanceMetrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Double getUsage() {
        return this.usage;
    }

    public Double getCapacity() {
        return this.capacity;
    }

    public Double getTotalHostCapacity() {
        return this.totalHostCapacity;
    }

    public Double getUtilizationPercent() {
        return this.utilizationPercent;
    }

    public Double getUsageChangePercent() {
        return this.usageChangePercent;
    }

    public List<InstanceMetrics> getInstanceMetrics() {
        return this.instanceMetrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExadataInsightResourceStatistics(");
        sb.append("super=").append(super.toString());
        sb.append("usage=").append(String.valueOf(this.usage));
        sb.append(", capacity=").append(String.valueOf(this.capacity));
        sb.append(", totalHostCapacity=").append(String.valueOf(this.totalHostCapacity));
        sb.append(", utilizationPercent=").append(String.valueOf(this.utilizationPercent));
        sb.append(", usageChangePercent=").append(String.valueOf(this.usageChangePercent));
        sb.append(", instanceMetrics=").append(String.valueOf(this.instanceMetrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExadataInsightResourceStatistics)) {
            return false;
        }
        ExadataInsightResourceStatistics other = (ExadataInsightResourceStatistics)((Object)o);
        return Objects.equals(this.usage, other.usage) && Objects.equals(this.capacity, other.capacity) && Objects.equals(this.totalHostCapacity, other.totalHostCapacity) && Objects.equals(this.utilizationPercent, other.utilizationPercent) && Objects.equals(this.usageChangePercent, other.usageChangePercent) && Objects.equals(this.instanceMetrics, other.instanceMetrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + (this.capacity == null ? 43 : this.capacity.hashCode());
        result = result * 59 + (this.totalHostCapacity == null ? 43 : this.totalHostCapacity.hashCode());
        result = result * 59 + (this.utilizationPercent == null ? 43 : this.utilizationPercent.hashCode());
        result = result * 59 + (this.usageChangePercent == null ? 43 : this.usageChangePercent.hashCode());
        result = result * 59 + (this.instanceMetrics == null ? 43 : this.instanceMetrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="usage")
        private Double usage;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="totalHostCapacity")
        private Double totalHostCapacity;
        @JsonProperty(value="utilizationPercent")
        private Double utilizationPercent;
        @JsonProperty(value="usageChangePercent")
        private Double usageChangePercent;
        @JsonProperty(value="instanceMetrics")
        private List<InstanceMetrics> instanceMetrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder usage(Double usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder totalHostCapacity(Double totalHostCapacity) {
            this.totalHostCapacity = totalHostCapacity;
            this.__explicitlySet__.add("totalHostCapacity");
            return this;
        }

        public Builder utilizationPercent(Double utilizationPercent) {
            this.utilizationPercent = utilizationPercent;
            this.__explicitlySet__.add("utilizationPercent");
            return this;
        }

        public Builder usageChangePercent(Double usageChangePercent) {
            this.usageChangePercent = usageChangePercent;
            this.__explicitlySet__.add("usageChangePercent");
            return this;
        }

        public Builder instanceMetrics(List<InstanceMetrics> instanceMetrics) {
            this.instanceMetrics = instanceMetrics;
            this.__explicitlySet__.add("instanceMetrics");
            return this;
        }

        public ExadataInsightResourceStatistics build() {
            ExadataInsightResourceStatistics model = new ExadataInsightResourceStatistics(this.usage, this.capacity, this.totalHostCapacity, this.utilizationPercent, this.usageChangePercent, this.instanceMetrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExadataInsightResourceStatistics model) {
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("totalHostCapacity")) {
                this.totalHostCapacity(model.getTotalHostCapacity());
            }
            if (model.wasPropertyExplicitlySet("utilizationPercent")) {
                this.utilizationPercent(model.getUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("usageChangePercent")) {
                this.usageChangePercent(model.getUsageChangePercent());
            }
            if (model.wasPropertyExplicitlySet("instanceMetrics")) {
                this.instanceMetrics(model.getInstanceMetrics());
            }
            return this;
        }
    }
}

