/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExadataMemberSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="entityType")
    private final EntityType entityType;

    @Deprecated
    @ConstructorProperties(value={"name", "displayName", "entityType"})
    public ExadataMemberSummary(String name, String displayName, EntityType entityType) {
        this.name = name;
        this.displayName = displayName;
        this.entityType = entityType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExadataMemberSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", entityType=").append(String.valueOf((Object)this.entityType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExadataMemberSummary)) {
            return false;
        }
        ExadataMemberSummary other = (ExadataMemberSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.entityType, (Object)other.entityType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EntityType implements BmcEnum
    {
        Database("DATABASE"),
        IlomServer("ILOM_SERVER"),
        Pdu("PDU"),
        StorageServer("STORAGE_SERVER"),
        ClusterAsm("CLUSTER_ASM"),
        InfinibandSwitch("INFINIBAND_SWITCH"),
        EthernetSwitch("ETHERNET_SWITCH"),
        Host("HOST"),
        VmCluster("VM_CLUSTER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EntityType> map;

        private EntityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EntityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EntityType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EntityType.class);
            map = new HashMap<String, EntityType>();
            for (EntityType v : EntityType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="entityType")
        private EntityType entityType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder entityType(EntityType entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public ExadataMemberSummary build() {
            ExadataMemberSummary model = new ExadataMemberSummary(this.name, this.displayName, this.entityType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExadataMemberSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            return this;
        }
    }
}

