/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostAllocation
extends DatabaseConfigurationMetricGroup {
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="resourceValue")
    private final Long resourceValue;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostAllocation(Date timeCollected, String resourceName, Long resourceValue) {
        super(timeCollected);
        this.resourceName = resourceName;
        this.resourceValue = resourceValue;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Long getResourceValue() {
        return this.resourceValue;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostAllocation(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", resourceValue=").append(String.valueOf(this.resourceValue));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAllocation)) {
            return false;
        }
        HostAllocation other = (HostAllocation)((Object)o);
        return Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.resourceValue, other.resourceValue) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceValue == null ? 43 : this.resourceValue.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="resourceValue")
        private Long resourceValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder resourceValue(Long resourceValue) {
            this.resourceValue = resourceValue;
            this.__explicitlySet__.add("resourceValue");
            return this;
        }

        public HostAllocation build() {
            HostAllocation model = new HostAllocation(this.timeCollected, this.resourceName, this.resourceValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostAllocation model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("resourceValue")) {
                this.resourceValue(model.getResourceValue());
            }
            return this;
        }
    }
}

