/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostContainers
extends HostConfigurationMetricGroup {
    @JsonProperty(value="containerId")
    private final String containerId;
    @JsonProperty(value="containerName")
    private final String containerName;
    @JsonProperty(value="containerImage")
    private final String containerImage;
    @JsonProperty(value="containerImageTag")
    private final String containerImageTag;
    @JsonProperty(value="containerImageDigest")
    private final String containerImageDigest;
    @JsonProperty(value="containerPorts")
    private final String containerPorts;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostContainers(Date timeCollected, String containerId, String containerName, String containerImage, String containerImageTag, String containerImageDigest, String containerPorts) {
        super(timeCollected);
        this.containerId = containerId;
        this.containerName = containerName;
        this.containerImage = containerImage;
        this.containerImageTag = containerImageTag;
        this.containerImageDigest = containerImageDigest;
        this.containerPorts = containerPorts;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getContainerImage() {
        return this.containerImage;
    }

    public String getContainerImageTag() {
        return this.containerImageTag;
    }

    public String getContainerImageDigest() {
        return this.containerImageDigest;
    }

    public String getContainerPorts() {
        return this.containerPorts;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostContainers(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", containerId=").append(String.valueOf(this.containerId));
        sb.append(", containerName=").append(String.valueOf(this.containerName));
        sb.append(", containerImage=").append(String.valueOf(this.containerImage));
        sb.append(", containerImageTag=").append(String.valueOf(this.containerImageTag));
        sb.append(", containerImageDigest=").append(String.valueOf(this.containerImageDigest));
        sb.append(", containerPorts=").append(String.valueOf(this.containerPorts));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostContainers)) {
            return false;
        }
        HostContainers other = (HostContainers)((Object)o);
        return Objects.equals(this.containerId, other.containerId) && Objects.equals(this.containerName, other.containerName) && Objects.equals(this.containerImage, other.containerImage) && Objects.equals(this.containerImageTag, other.containerImageTag) && Objects.equals(this.containerImageDigest, other.containerImageDigest) && Objects.equals(this.containerPorts, other.containerPorts) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.containerId == null ? 43 : this.containerId.hashCode());
        result = result * 59 + (this.containerName == null ? 43 : this.containerName.hashCode());
        result = result * 59 + (this.containerImage == null ? 43 : this.containerImage.hashCode());
        result = result * 59 + (this.containerImageTag == null ? 43 : this.containerImageTag.hashCode());
        result = result * 59 + (this.containerImageDigest == null ? 43 : this.containerImageDigest.hashCode());
        result = result * 59 + (this.containerPorts == null ? 43 : this.containerPorts.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="containerId")
        private String containerId;
        @JsonProperty(value="containerName")
        private String containerName;
        @JsonProperty(value="containerImage")
        private String containerImage;
        @JsonProperty(value="containerImageTag")
        private String containerImageTag;
        @JsonProperty(value="containerImageDigest")
        private String containerImageDigest;
        @JsonProperty(value="containerPorts")
        private String containerPorts;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder containerId(String containerId) {
            this.containerId = containerId;
            this.__explicitlySet__.add("containerId");
            return this;
        }

        public Builder containerName(String containerName) {
            this.containerName = containerName;
            this.__explicitlySet__.add("containerName");
            return this;
        }

        public Builder containerImage(String containerImage) {
            this.containerImage = containerImage;
            this.__explicitlySet__.add("containerImage");
            return this;
        }

        public Builder containerImageTag(String containerImageTag) {
            this.containerImageTag = containerImageTag;
            this.__explicitlySet__.add("containerImageTag");
            return this;
        }

        public Builder containerImageDigest(String containerImageDigest) {
            this.containerImageDigest = containerImageDigest;
            this.__explicitlySet__.add("containerImageDigest");
            return this;
        }

        public Builder containerPorts(String containerPorts) {
            this.containerPorts = containerPorts;
            this.__explicitlySet__.add("containerPorts");
            return this;
        }

        public HostContainers build() {
            HostContainers model = new HostContainers(this.timeCollected, this.containerId, this.containerName, this.containerImage, this.containerImageTag, this.containerImageDigest, this.containerPorts);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostContainers model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("containerId")) {
                this.containerId(model.getContainerId());
            }
            if (model.wasPropertyExplicitlySet("containerName")) {
                this.containerName(model.getContainerName());
            }
            if (model.wasPropertyExplicitlySet("containerImage")) {
                this.containerImage(model.getContainerImage());
            }
            if (model.wasPropertyExplicitlySet("containerImageTag")) {
                this.containerImageTag(model.getContainerImageTag());
            }
            if (model.wasPropertyExplicitlySet("containerImageDigest")) {
                this.containerImageDigest(model.getContainerImageDigest());
            }
            if (model.wasPropertyExplicitlySet("containerPorts")) {
                this.containerPorts(model.getContainerPorts());
            }
            return this;
        }
    }
}

