/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostGpuConfiguration
extends HostConfigurationMetricGroup {
    @JsonProperty(value="gpuId")
    private final Integer gpuId;
    @JsonProperty(value="productName")
    private final String productName;
    @JsonProperty(value="vendor")
    private final String vendor;
    @JsonProperty(value="busId")
    private final String busId;
    @JsonProperty(value="busWidth")
    private final Integer busWidth;
    @JsonProperty(value="gpuCapabilities")
    private final String gpuCapabilities;
    @JsonProperty(value="totalPower")
    private final Double totalPower;
    @JsonProperty(value="totalMemory")
    private final Double totalMemory;
    @JsonProperty(value="totalVideoClockSpeed")
    private final Double totalVideoClockSpeed;
    @JsonProperty(value="totalSmClockSpeed")
    private final Double totalSmClockSpeed;
    @JsonProperty(value="totalGraphicsClockSpeed")
    private final Double totalGraphicsClockSpeed;
    @JsonProperty(value="totalMemoryClockSpeed")
    private final Double totalMemoryClockSpeed;
    @JsonProperty(value="cudaVersion")
    private final String cudaVersion;
    @JsonProperty(value="driverVersion")
    private final String driverVersion;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostGpuConfiguration(Date timeCollected, Integer gpuId, String productName, String vendor, String busId, Integer busWidth, String gpuCapabilities, Double totalPower, Double totalMemory, Double totalVideoClockSpeed, Double totalSmClockSpeed, Double totalGraphicsClockSpeed, Double totalMemoryClockSpeed, String cudaVersion, String driverVersion) {
        super(timeCollected);
        this.gpuId = gpuId;
        this.productName = productName;
        this.vendor = vendor;
        this.busId = busId;
        this.busWidth = busWidth;
        this.gpuCapabilities = gpuCapabilities;
        this.totalPower = totalPower;
        this.totalMemory = totalMemory;
        this.totalVideoClockSpeed = totalVideoClockSpeed;
        this.totalSmClockSpeed = totalSmClockSpeed;
        this.totalGraphicsClockSpeed = totalGraphicsClockSpeed;
        this.totalMemoryClockSpeed = totalMemoryClockSpeed;
        this.cudaVersion = cudaVersion;
        this.driverVersion = driverVersion;
    }

    public Integer getGpuId() {
        return this.gpuId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getBusId() {
        return this.busId;
    }

    public Integer getBusWidth() {
        return this.busWidth;
    }

    public String getGpuCapabilities() {
        return this.gpuCapabilities;
    }

    public Double getTotalPower() {
        return this.totalPower;
    }

    public Double getTotalMemory() {
        return this.totalMemory;
    }

    public Double getTotalVideoClockSpeed() {
        return this.totalVideoClockSpeed;
    }

    public Double getTotalSmClockSpeed() {
        return this.totalSmClockSpeed;
    }

    public Double getTotalGraphicsClockSpeed() {
        return this.totalGraphicsClockSpeed;
    }

    public Double getTotalMemoryClockSpeed() {
        return this.totalMemoryClockSpeed;
    }

    public String getCudaVersion() {
        return this.cudaVersion;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostGpuConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", gpuId=").append(String.valueOf(this.gpuId));
        sb.append(", productName=").append(String.valueOf(this.productName));
        sb.append(", vendor=").append(String.valueOf(this.vendor));
        sb.append(", busId=").append(String.valueOf(this.busId));
        sb.append(", busWidth=").append(String.valueOf(this.busWidth));
        sb.append(", gpuCapabilities=").append(String.valueOf(this.gpuCapabilities));
        sb.append(", totalPower=").append(String.valueOf(this.totalPower));
        sb.append(", totalMemory=").append(String.valueOf(this.totalMemory));
        sb.append(", totalVideoClockSpeed=").append(String.valueOf(this.totalVideoClockSpeed));
        sb.append(", totalSmClockSpeed=").append(String.valueOf(this.totalSmClockSpeed));
        sb.append(", totalGraphicsClockSpeed=").append(String.valueOf(this.totalGraphicsClockSpeed));
        sb.append(", totalMemoryClockSpeed=").append(String.valueOf(this.totalMemoryClockSpeed));
        sb.append(", cudaVersion=").append(String.valueOf(this.cudaVersion));
        sb.append(", driverVersion=").append(String.valueOf(this.driverVersion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostGpuConfiguration)) {
            return false;
        }
        HostGpuConfiguration other = (HostGpuConfiguration)((Object)o);
        return Objects.equals(this.gpuId, other.gpuId) && Objects.equals(this.productName, other.productName) && Objects.equals(this.vendor, other.vendor) && Objects.equals(this.busId, other.busId) && Objects.equals(this.busWidth, other.busWidth) && Objects.equals(this.gpuCapabilities, other.gpuCapabilities) && Objects.equals(this.totalPower, other.totalPower) && Objects.equals(this.totalMemory, other.totalMemory) && Objects.equals(this.totalVideoClockSpeed, other.totalVideoClockSpeed) && Objects.equals(this.totalSmClockSpeed, other.totalSmClockSpeed) && Objects.equals(this.totalGraphicsClockSpeed, other.totalGraphicsClockSpeed) && Objects.equals(this.totalMemoryClockSpeed, other.totalMemoryClockSpeed) && Objects.equals(this.cudaVersion, other.cudaVersion) && Objects.equals(this.driverVersion, other.driverVersion) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.gpuId == null ? 43 : this.gpuId.hashCode());
        result = result * 59 + (this.productName == null ? 43 : this.productName.hashCode());
        result = result * 59 + (this.vendor == null ? 43 : this.vendor.hashCode());
        result = result * 59 + (this.busId == null ? 43 : this.busId.hashCode());
        result = result * 59 + (this.busWidth == null ? 43 : this.busWidth.hashCode());
        result = result * 59 + (this.gpuCapabilities == null ? 43 : this.gpuCapabilities.hashCode());
        result = result * 59 + (this.totalPower == null ? 43 : this.totalPower.hashCode());
        result = result * 59 + (this.totalMemory == null ? 43 : this.totalMemory.hashCode());
        result = result * 59 + (this.totalVideoClockSpeed == null ? 43 : this.totalVideoClockSpeed.hashCode());
        result = result * 59 + (this.totalSmClockSpeed == null ? 43 : this.totalSmClockSpeed.hashCode());
        result = result * 59 + (this.totalGraphicsClockSpeed == null ? 43 : this.totalGraphicsClockSpeed.hashCode());
        result = result * 59 + (this.totalMemoryClockSpeed == null ? 43 : this.totalMemoryClockSpeed.hashCode());
        result = result * 59 + (this.cudaVersion == null ? 43 : this.cudaVersion.hashCode());
        result = result * 59 + (this.driverVersion == null ? 43 : this.driverVersion.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="gpuId")
        private Integer gpuId;
        @JsonProperty(value="productName")
        private String productName;
        @JsonProperty(value="vendor")
        private String vendor;
        @JsonProperty(value="busId")
        private String busId;
        @JsonProperty(value="busWidth")
        private Integer busWidth;
        @JsonProperty(value="gpuCapabilities")
        private String gpuCapabilities;
        @JsonProperty(value="totalPower")
        private Double totalPower;
        @JsonProperty(value="totalMemory")
        private Double totalMemory;
        @JsonProperty(value="totalVideoClockSpeed")
        private Double totalVideoClockSpeed;
        @JsonProperty(value="totalSmClockSpeed")
        private Double totalSmClockSpeed;
        @JsonProperty(value="totalGraphicsClockSpeed")
        private Double totalGraphicsClockSpeed;
        @JsonProperty(value="totalMemoryClockSpeed")
        private Double totalMemoryClockSpeed;
        @JsonProperty(value="cudaVersion")
        private String cudaVersion;
        @JsonProperty(value="driverVersion")
        private String driverVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder gpuId(Integer gpuId) {
            this.gpuId = gpuId;
            this.__explicitlySet__.add("gpuId");
            return this;
        }

        public Builder productName(String productName) {
            this.productName = productName;
            this.__explicitlySet__.add("productName");
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.__explicitlySet__.add("vendor");
            return this;
        }

        public Builder busId(String busId) {
            this.busId = busId;
            this.__explicitlySet__.add("busId");
            return this;
        }

        public Builder busWidth(Integer busWidth) {
            this.busWidth = busWidth;
            this.__explicitlySet__.add("busWidth");
            return this;
        }

        public Builder gpuCapabilities(String gpuCapabilities) {
            this.gpuCapabilities = gpuCapabilities;
            this.__explicitlySet__.add("gpuCapabilities");
            return this;
        }

        public Builder totalPower(Double totalPower) {
            this.totalPower = totalPower;
            this.__explicitlySet__.add("totalPower");
            return this;
        }

        public Builder totalMemory(Double totalMemory) {
            this.totalMemory = totalMemory;
            this.__explicitlySet__.add("totalMemory");
            return this;
        }

        public Builder totalVideoClockSpeed(Double totalVideoClockSpeed) {
            this.totalVideoClockSpeed = totalVideoClockSpeed;
            this.__explicitlySet__.add("totalVideoClockSpeed");
            return this;
        }

        public Builder totalSmClockSpeed(Double totalSmClockSpeed) {
            this.totalSmClockSpeed = totalSmClockSpeed;
            this.__explicitlySet__.add("totalSmClockSpeed");
            return this;
        }

        public Builder totalGraphicsClockSpeed(Double totalGraphicsClockSpeed) {
            this.totalGraphicsClockSpeed = totalGraphicsClockSpeed;
            this.__explicitlySet__.add("totalGraphicsClockSpeed");
            return this;
        }

        public Builder totalMemoryClockSpeed(Double totalMemoryClockSpeed) {
            this.totalMemoryClockSpeed = totalMemoryClockSpeed;
            this.__explicitlySet__.add("totalMemoryClockSpeed");
            return this;
        }

        public Builder cudaVersion(String cudaVersion) {
            this.cudaVersion = cudaVersion;
            this.__explicitlySet__.add("cudaVersion");
            return this;
        }

        public Builder driverVersion(String driverVersion) {
            this.driverVersion = driverVersion;
            this.__explicitlySet__.add("driverVersion");
            return this;
        }

        public HostGpuConfiguration build() {
            HostGpuConfiguration model = new HostGpuConfiguration(this.timeCollected, this.gpuId, this.productName, this.vendor, this.busId, this.busWidth, this.gpuCapabilities, this.totalPower, this.totalMemory, this.totalVideoClockSpeed, this.totalSmClockSpeed, this.totalGraphicsClockSpeed, this.totalMemoryClockSpeed, this.cudaVersion, this.driverVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostGpuConfiguration model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("gpuId")) {
                this.gpuId(model.getGpuId());
            }
            if (model.wasPropertyExplicitlySet("productName")) {
                this.productName(model.getProductName());
            }
            if (model.wasPropertyExplicitlySet("vendor")) {
                this.vendor(model.getVendor());
            }
            if (model.wasPropertyExplicitlySet("busId")) {
                this.busId(model.getBusId());
            }
            if (model.wasPropertyExplicitlySet("busWidth")) {
                this.busWidth(model.getBusWidth());
            }
            if (model.wasPropertyExplicitlySet("gpuCapabilities")) {
                this.gpuCapabilities(model.getGpuCapabilities());
            }
            if (model.wasPropertyExplicitlySet("totalPower")) {
                this.totalPower(model.getTotalPower());
            }
            if (model.wasPropertyExplicitlySet("totalMemory")) {
                this.totalMemory(model.getTotalMemory());
            }
            if (model.wasPropertyExplicitlySet("totalVideoClockSpeed")) {
                this.totalVideoClockSpeed(model.getTotalVideoClockSpeed());
            }
            if (model.wasPropertyExplicitlySet("totalSmClockSpeed")) {
                this.totalSmClockSpeed(model.getTotalSmClockSpeed());
            }
            if (model.wasPropertyExplicitlySet("totalGraphicsClockSpeed")) {
                this.totalGraphicsClockSpeed(model.getTotalGraphicsClockSpeed());
            }
            if (model.wasPropertyExplicitlySet("totalMemoryClockSpeed")) {
                this.totalMemoryClockSpeed(model.getTotalMemoryClockSpeed());
            }
            if (model.wasPropertyExplicitlySet("cudaVersion")) {
                this.cudaVersion(model.getCudaVersion());
            }
            if (model.wasPropertyExplicitlySet("driverVersion")) {
                this.driverVersion(model.getDriverVersion());
            }
            return this;
        }
    }
}

