/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostPerformanceMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostGpuProcesses
extends HostPerformanceMetricGroup {
    @JsonProperty(value="gpuId")
    private final Integer gpuId;
    @JsonProperty(value="pid")
    private final Integer pid;
    @JsonProperty(value="processName")
    private final String processName;
    @JsonProperty(value="elapsedTime")
    private final Double elapsedTime;
    @JsonProperty(value="gpuMemoryUsage")
    private final Double gpuMemoryUsage;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostGpuProcesses(Date timeCollected, Integer gpuId, Integer pid, String processName, Double elapsedTime, Double gpuMemoryUsage) {
        super(timeCollected);
        this.gpuId = gpuId;
        this.pid = pid;
        this.processName = processName;
        this.elapsedTime = elapsedTime;
        this.gpuMemoryUsage = gpuMemoryUsage;
    }

    public Integer getGpuId() {
        return this.gpuId;
    }

    public Integer getPid() {
        return this.pid;
    }

    public String getProcessName() {
        return this.processName;
    }

    public Double getElapsedTime() {
        return this.elapsedTime;
    }

    public Double getGpuMemoryUsage() {
        return this.gpuMemoryUsage;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostGpuProcesses(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", gpuId=").append(String.valueOf(this.gpuId));
        sb.append(", pid=").append(String.valueOf(this.pid));
        sb.append(", processName=").append(String.valueOf(this.processName));
        sb.append(", elapsedTime=").append(String.valueOf(this.elapsedTime));
        sb.append(", gpuMemoryUsage=").append(String.valueOf(this.gpuMemoryUsage));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostGpuProcesses)) {
            return false;
        }
        HostGpuProcesses other = (HostGpuProcesses)((Object)o);
        return Objects.equals(this.gpuId, other.gpuId) && Objects.equals(this.pid, other.pid) && Objects.equals(this.processName, other.processName) && Objects.equals(this.elapsedTime, other.elapsedTime) && Objects.equals(this.gpuMemoryUsage, other.gpuMemoryUsage) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.gpuId == null ? 43 : this.gpuId.hashCode());
        result = result * 59 + (this.pid == null ? 43 : this.pid.hashCode());
        result = result * 59 + (this.processName == null ? 43 : this.processName.hashCode());
        result = result * 59 + (this.elapsedTime == null ? 43 : this.elapsedTime.hashCode());
        result = result * 59 + (this.gpuMemoryUsage == null ? 43 : this.gpuMemoryUsage.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="gpuId")
        private Integer gpuId;
        @JsonProperty(value="pid")
        private Integer pid;
        @JsonProperty(value="processName")
        private String processName;
        @JsonProperty(value="elapsedTime")
        private Double elapsedTime;
        @JsonProperty(value="gpuMemoryUsage")
        private Double gpuMemoryUsage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder gpuId(Integer gpuId) {
            this.gpuId = gpuId;
            this.__explicitlySet__.add("gpuId");
            return this;
        }

        public Builder pid(Integer pid) {
            this.pid = pid;
            this.__explicitlySet__.add("pid");
            return this;
        }

        public Builder processName(String processName) {
            this.processName = processName;
            this.__explicitlySet__.add("processName");
            return this;
        }

        public Builder elapsedTime(Double elapsedTime) {
            this.elapsedTime = elapsedTime;
            this.__explicitlySet__.add("elapsedTime");
            return this;
        }

        public Builder gpuMemoryUsage(Double gpuMemoryUsage) {
            this.gpuMemoryUsage = gpuMemoryUsage;
            this.__explicitlySet__.add("gpuMemoryUsage");
            return this;
        }

        public HostGpuProcesses build() {
            HostGpuProcesses model = new HostGpuProcesses(this.timeCollected, this.gpuId, this.pid, this.processName, this.elapsedTime, this.gpuMemoryUsage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostGpuProcesses model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("gpuId")) {
                this.gpuId(model.getGpuId());
            }
            if (model.wasPropertyExplicitlySet("pid")) {
                this.pid(model.getPid());
            }
            if (model.wasPropertyExplicitlySet("processName")) {
                this.processName(model.getProcessName());
            }
            if (model.wasPropertyExplicitlySet("elapsedTime")) {
                this.elapsedTime(model.getElapsedTime());
            }
            if (model.wasPropertyExplicitlySet("gpuMemoryUsage")) {
                this.gpuMemoryUsage(model.getGpuMemoryUsage());
            }
            return this;
        }
    }
}

