/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostResourceStatistics;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceName")
@JsonFilter(value="explicitlySetFilter")
public final class HostIoStatistics
extends HostResourceStatistics {
    @JsonProperty(value="diskReadInMBs")
    private final Double diskReadInMBs;
    @JsonProperty(value="diskWriteInMBs")
    private final Double diskWriteInMBs;
    @JsonProperty(value="diskIops")
    private final Double diskIops;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostIoStatistics(Double usage, Double capacity, Double utilizationPercent, Double usageChangePercent, Double diskReadInMBs, Double diskWriteInMBs, Double diskIops) {
        super(usage, capacity, utilizationPercent, usageChangePercent);
        this.diskReadInMBs = diskReadInMBs;
        this.diskWriteInMBs = diskWriteInMBs;
        this.diskIops = diskIops;
    }

    public Double getDiskReadInMBs() {
        return this.diskReadInMBs;
    }

    public Double getDiskWriteInMBs() {
        return this.diskWriteInMBs;
    }

    public Double getDiskIops() {
        return this.diskIops;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostIoStatistics(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", diskReadInMBs=").append(String.valueOf(this.diskReadInMBs));
        sb.append(", diskWriteInMBs=").append(String.valueOf(this.diskWriteInMBs));
        sb.append(", diskIops=").append(String.valueOf(this.diskIops));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostIoStatistics)) {
            return false;
        }
        HostIoStatistics other = (HostIoStatistics)((Object)o);
        return Objects.equals(this.diskReadInMBs, other.diskReadInMBs) && Objects.equals(this.diskWriteInMBs, other.diskWriteInMBs) && Objects.equals(this.diskIops, other.diskIops) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.diskReadInMBs == null ? 43 : this.diskReadInMBs.hashCode());
        result = result * 59 + (this.diskWriteInMBs == null ? 43 : this.diskWriteInMBs.hashCode());
        result = result * 59 + (this.diskIops == null ? 43 : this.diskIops.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="usage")
        private Double usage;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="utilizationPercent")
        private Double utilizationPercent;
        @JsonProperty(value="usageChangePercent")
        private Double usageChangePercent;
        @JsonProperty(value="diskReadInMBs")
        private Double diskReadInMBs;
        @JsonProperty(value="diskWriteInMBs")
        private Double diskWriteInMBs;
        @JsonProperty(value="diskIops")
        private Double diskIops;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder usage(Double usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder utilizationPercent(Double utilizationPercent) {
            this.utilizationPercent = utilizationPercent;
            this.__explicitlySet__.add("utilizationPercent");
            return this;
        }

        public Builder usageChangePercent(Double usageChangePercent) {
            this.usageChangePercent = usageChangePercent;
            this.__explicitlySet__.add("usageChangePercent");
            return this;
        }

        public Builder diskReadInMBs(Double diskReadInMBs) {
            this.diskReadInMBs = diskReadInMBs;
            this.__explicitlySet__.add("diskReadInMBs");
            return this;
        }

        public Builder diskWriteInMBs(Double diskWriteInMBs) {
            this.diskWriteInMBs = diskWriteInMBs;
            this.__explicitlySet__.add("diskWriteInMBs");
            return this;
        }

        public Builder diskIops(Double diskIops) {
            this.diskIops = diskIops;
            this.__explicitlySet__.add("diskIops");
            return this;
        }

        public HostIoStatistics build() {
            HostIoStatistics model = new HostIoStatistics(this.usage, this.capacity, this.utilizationPercent, this.usageChangePercent, this.diskReadInMBs, this.diskWriteInMBs, this.diskIops);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostIoStatistics model) {
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("utilizationPercent")) {
                this.utilizationPercent(model.getUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("usageChangePercent")) {
                this.usageChangePercent(model.getUsageChangePercent());
            }
            if (model.wasPropertyExplicitlySet("diskReadInMBs")) {
                this.diskReadInMBs(model.getDiskReadInMBs());
            }
            if (model.wasPropertyExplicitlySet("diskWriteInMBs")) {
                this.diskWriteInMBs(model.getDiskWriteInMBs());
            }
            if (model.wasPropertyExplicitlySet("diskIops")) {
                this.diskIops(model.getDiskIops());
            }
            return this;
        }
    }
}

