/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostPerformanceMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostIoUsage
extends HostPerformanceMetricGroup {
    @JsonProperty(value="mountPoint")
    private final String mountPoint;
    @JsonProperty(value="diskBytesRead")
    private final Double diskBytesRead;
    @JsonProperty(value="diskBytesWritten")
    private final Double diskBytesWritten;
    @JsonProperty(value="diskIopsRead")
    private final Double diskIopsRead;
    @JsonProperty(value="diskIopsWritten")
    private final Double diskIopsWritten;
    @JsonProperty(value="diskIops")
    private final Double diskIops;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostIoUsage(Date timeCollected, String mountPoint, Double diskBytesRead, Double diskBytesWritten, Double diskIopsRead, Double diskIopsWritten, Double diskIops) {
        super(timeCollected);
        this.mountPoint = mountPoint;
        this.diskBytesRead = diskBytesRead;
        this.diskBytesWritten = diskBytesWritten;
        this.diskIopsRead = diskIopsRead;
        this.diskIopsWritten = diskIopsWritten;
        this.diskIops = diskIops;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public Double getDiskBytesRead() {
        return this.diskBytesRead;
    }

    public Double getDiskBytesWritten() {
        return this.diskBytesWritten;
    }

    public Double getDiskIopsRead() {
        return this.diskIopsRead;
    }

    public Double getDiskIopsWritten() {
        return this.diskIopsWritten;
    }

    public Double getDiskIops() {
        return this.diskIops;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostIoUsage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", mountPoint=").append(String.valueOf(this.mountPoint));
        sb.append(", diskBytesRead=").append(String.valueOf(this.diskBytesRead));
        sb.append(", diskBytesWritten=").append(String.valueOf(this.diskBytesWritten));
        sb.append(", diskIopsRead=").append(String.valueOf(this.diskIopsRead));
        sb.append(", diskIopsWritten=").append(String.valueOf(this.diskIopsWritten));
        sb.append(", diskIops=").append(String.valueOf(this.diskIops));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostIoUsage)) {
            return false;
        }
        HostIoUsage other = (HostIoUsage)((Object)o);
        return Objects.equals(this.mountPoint, other.mountPoint) && Objects.equals(this.diskBytesRead, other.diskBytesRead) && Objects.equals(this.diskBytesWritten, other.diskBytesWritten) && Objects.equals(this.diskIopsRead, other.diskIopsRead) && Objects.equals(this.diskIopsWritten, other.diskIopsWritten) && Objects.equals(this.diskIops, other.diskIops) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mountPoint == null ? 43 : this.mountPoint.hashCode());
        result = result * 59 + (this.diskBytesRead == null ? 43 : this.diskBytesRead.hashCode());
        result = result * 59 + (this.diskBytesWritten == null ? 43 : this.diskBytesWritten.hashCode());
        result = result * 59 + (this.diskIopsRead == null ? 43 : this.diskIopsRead.hashCode());
        result = result * 59 + (this.diskIopsWritten == null ? 43 : this.diskIopsWritten.hashCode());
        result = result * 59 + (this.diskIops == null ? 43 : this.diskIops.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="mountPoint")
        private String mountPoint;
        @JsonProperty(value="diskBytesRead")
        private Double diskBytesRead;
        @JsonProperty(value="diskBytesWritten")
        private Double diskBytesWritten;
        @JsonProperty(value="diskIopsRead")
        private Double diskIopsRead;
        @JsonProperty(value="diskIopsWritten")
        private Double diskIopsWritten;
        @JsonProperty(value="diskIops")
        private Double diskIops;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            this.__explicitlySet__.add("mountPoint");
            return this;
        }

        public Builder diskBytesRead(Double diskBytesRead) {
            this.diskBytesRead = diskBytesRead;
            this.__explicitlySet__.add("diskBytesRead");
            return this;
        }

        public Builder diskBytesWritten(Double diskBytesWritten) {
            this.diskBytesWritten = diskBytesWritten;
            this.__explicitlySet__.add("diskBytesWritten");
            return this;
        }

        public Builder diskIopsRead(Double diskIopsRead) {
            this.diskIopsRead = diskIopsRead;
            this.__explicitlySet__.add("diskIopsRead");
            return this;
        }

        public Builder diskIopsWritten(Double diskIopsWritten) {
            this.diskIopsWritten = diskIopsWritten;
            this.__explicitlySet__.add("diskIopsWritten");
            return this;
        }

        public Builder diskIops(Double diskIops) {
            this.diskIops = diskIops;
            this.__explicitlySet__.add("diskIops");
            return this;
        }

        public HostIoUsage build() {
            HostIoUsage model = new HostIoUsage(this.timeCollected, this.mountPoint, this.diskBytesRead, this.diskBytesWritten, this.diskIopsRead, this.diskIopsWritten, this.diskIops);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostIoUsage model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("mountPoint")) {
                this.mountPoint(model.getMountPoint());
            }
            if (model.wasPropertyExplicitlySet("diskBytesRead")) {
                this.diskBytesRead(model.getDiskBytesRead());
            }
            if (model.wasPropertyExplicitlySet("diskBytesWritten")) {
                this.diskBytesWritten(model.getDiskBytesWritten());
            }
            if (model.wasPropertyExplicitlySet("diskIopsRead")) {
                this.diskIopsRead(model.getDiskIopsRead());
            }
            if (model.wasPropertyExplicitlySet("diskIopsWritten")) {
                this.diskIopsWritten(model.getDiskIopsWritten());
            }
            if (model.wasPropertyExplicitlySet("diskIops")) {
                this.diskIops(model.getDiskIops());
            }
            return this;
        }
    }
}

