/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostMemoryConfiguration
extends HostConfigurationMetricGroup {
    @JsonProperty(value="pageSizeInKB")
    private final Double pageSizeInKB;
    @JsonProperty(value="pageTablesInKB")
    private final Double pageTablesInKB;
    @JsonProperty(value="swapTotalInKB")
    private final Double swapTotalInKB;
    @JsonProperty(value="hugePageSizeInKB")
    private final Double hugePageSizeInKB;
    @JsonProperty(value="hugePagesTotal")
    private final Integer hugePagesTotal;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostMemoryConfiguration(Date timeCollected, Double pageSizeInKB, Double pageTablesInKB, Double swapTotalInKB, Double hugePageSizeInKB, Integer hugePagesTotal) {
        super(timeCollected);
        this.pageSizeInKB = pageSizeInKB;
        this.pageTablesInKB = pageTablesInKB;
        this.swapTotalInKB = swapTotalInKB;
        this.hugePageSizeInKB = hugePageSizeInKB;
        this.hugePagesTotal = hugePagesTotal;
    }

    public Double getPageSizeInKB() {
        return this.pageSizeInKB;
    }

    public Double getPageTablesInKB() {
        return this.pageTablesInKB;
    }

    public Double getSwapTotalInKB() {
        return this.swapTotalInKB;
    }

    public Double getHugePageSizeInKB() {
        return this.hugePageSizeInKB;
    }

    public Integer getHugePagesTotal() {
        return this.hugePagesTotal;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostMemoryConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", pageSizeInKB=").append(String.valueOf(this.pageSizeInKB));
        sb.append(", pageTablesInKB=").append(String.valueOf(this.pageTablesInKB));
        sb.append(", swapTotalInKB=").append(String.valueOf(this.swapTotalInKB));
        sb.append(", hugePageSizeInKB=").append(String.valueOf(this.hugePageSizeInKB));
        sb.append(", hugePagesTotal=").append(String.valueOf(this.hugePagesTotal));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostMemoryConfiguration)) {
            return false;
        }
        HostMemoryConfiguration other = (HostMemoryConfiguration)((Object)o);
        return Objects.equals(this.pageSizeInKB, other.pageSizeInKB) && Objects.equals(this.pageTablesInKB, other.pageTablesInKB) && Objects.equals(this.swapTotalInKB, other.swapTotalInKB) && Objects.equals(this.hugePageSizeInKB, other.hugePageSizeInKB) && Objects.equals(this.hugePagesTotal, other.hugePagesTotal) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pageSizeInKB == null ? 43 : this.pageSizeInKB.hashCode());
        result = result * 59 + (this.pageTablesInKB == null ? 43 : this.pageTablesInKB.hashCode());
        result = result * 59 + (this.swapTotalInKB == null ? 43 : this.swapTotalInKB.hashCode());
        result = result * 59 + (this.hugePageSizeInKB == null ? 43 : this.hugePageSizeInKB.hashCode());
        result = result * 59 + (this.hugePagesTotal == null ? 43 : this.hugePagesTotal.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="pageSizeInKB")
        private Double pageSizeInKB;
        @JsonProperty(value="pageTablesInKB")
        private Double pageTablesInKB;
        @JsonProperty(value="swapTotalInKB")
        private Double swapTotalInKB;
        @JsonProperty(value="hugePageSizeInKB")
        private Double hugePageSizeInKB;
        @JsonProperty(value="hugePagesTotal")
        private Integer hugePagesTotal;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder pageSizeInKB(Double pageSizeInKB) {
            this.pageSizeInKB = pageSizeInKB;
            this.__explicitlySet__.add("pageSizeInKB");
            return this;
        }

        public Builder pageTablesInKB(Double pageTablesInKB) {
            this.pageTablesInKB = pageTablesInKB;
            this.__explicitlySet__.add("pageTablesInKB");
            return this;
        }

        public Builder swapTotalInKB(Double swapTotalInKB) {
            this.swapTotalInKB = swapTotalInKB;
            this.__explicitlySet__.add("swapTotalInKB");
            return this;
        }

        public Builder hugePageSizeInKB(Double hugePageSizeInKB) {
            this.hugePageSizeInKB = hugePageSizeInKB;
            this.__explicitlySet__.add("hugePageSizeInKB");
            return this;
        }

        public Builder hugePagesTotal(Integer hugePagesTotal) {
            this.hugePagesTotal = hugePagesTotal;
            this.__explicitlySet__.add("hugePagesTotal");
            return this;
        }

        public HostMemoryConfiguration build() {
            HostMemoryConfiguration model = new HostMemoryConfiguration(this.timeCollected, this.pageSizeInKB, this.pageTablesInKB, this.swapTotalInKB, this.hugePageSizeInKB, this.hugePagesTotal);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostMemoryConfiguration model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("pageSizeInKB")) {
                this.pageSizeInKB(model.getPageSizeInKB());
            }
            if (model.wasPropertyExplicitlySet("pageTablesInKB")) {
                this.pageTablesInKB(model.getPageTablesInKB());
            }
            if (model.wasPropertyExplicitlySet("swapTotalInKB")) {
                this.swapTotalInKB(model.getSwapTotalInKB());
            }
            if (model.wasPropertyExplicitlySet("hugePageSizeInKB")) {
                this.hugePageSizeInKB(model.getHugePageSizeInKB());
            }
            if (model.wasPropertyExplicitlySet("hugePagesTotal")) {
                this.hugePagesTotal(model.getHugePagesTotal());
            }
            return this;
        }
    }
}

