/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostResourceStatistics;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceName")
@JsonFilter(value="explicitlySetFilter")
public final class HostNetworkStatistics
extends HostResourceStatistics {
    @JsonProperty(value="networkReadInMBs")
    private final Double networkReadInMBs;
    @JsonProperty(value="networkWriteInMBs")
    private final Double networkWriteInMBs;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostNetworkStatistics(Double usage, Double capacity, Double utilizationPercent, Double usageChangePercent, Double networkReadInMBs, Double networkWriteInMBs) {
        super(usage, capacity, utilizationPercent, usageChangePercent);
        this.networkReadInMBs = networkReadInMBs;
        this.networkWriteInMBs = networkWriteInMBs;
    }

    public Double getNetworkReadInMBs() {
        return this.networkReadInMBs;
    }

    public Double getNetworkWriteInMBs() {
        return this.networkWriteInMBs;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostNetworkStatistics(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", networkReadInMBs=").append(String.valueOf(this.networkReadInMBs));
        sb.append(", networkWriteInMBs=").append(String.valueOf(this.networkWriteInMBs));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostNetworkStatistics)) {
            return false;
        }
        HostNetworkStatistics other = (HostNetworkStatistics)((Object)o);
        return Objects.equals(this.networkReadInMBs, other.networkReadInMBs) && Objects.equals(this.networkWriteInMBs, other.networkWriteInMBs) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkReadInMBs == null ? 43 : this.networkReadInMBs.hashCode());
        result = result * 59 + (this.networkWriteInMBs == null ? 43 : this.networkWriteInMBs.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="usage")
        private Double usage;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="utilizationPercent")
        private Double utilizationPercent;
        @JsonProperty(value="usageChangePercent")
        private Double usageChangePercent;
        @JsonProperty(value="networkReadInMBs")
        private Double networkReadInMBs;
        @JsonProperty(value="networkWriteInMBs")
        private Double networkWriteInMBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder usage(Double usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder utilizationPercent(Double utilizationPercent) {
            this.utilizationPercent = utilizationPercent;
            this.__explicitlySet__.add("utilizationPercent");
            return this;
        }

        public Builder usageChangePercent(Double usageChangePercent) {
            this.usageChangePercent = usageChangePercent;
            this.__explicitlySet__.add("usageChangePercent");
            return this;
        }

        public Builder networkReadInMBs(Double networkReadInMBs) {
            this.networkReadInMBs = networkReadInMBs;
            this.__explicitlySet__.add("networkReadInMBs");
            return this;
        }

        public Builder networkWriteInMBs(Double networkWriteInMBs) {
            this.networkWriteInMBs = networkWriteInMBs;
            this.__explicitlySet__.add("networkWriteInMBs");
            return this;
        }

        public HostNetworkStatistics build() {
            HostNetworkStatistics model = new HostNetworkStatistics(this.usage, this.capacity, this.utilizationPercent, this.usageChangePercent, this.networkReadInMBs, this.networkWriteInMBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostNetworkStatistics model) {
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("utilizationPercent")) {
                this.utilizationPercent(model.getUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("usageChangePercent")) {
                this.usageChangePercent(model.getUsageChangePercent());
            }
            if (model.wasPropertyExplicitlySet("networkReadInMBs")) {
                this.networkReadInMBs(model.getNetworkReadInMBs());
            }
            if (model.wasPropertyExplicitlySet("networkWriteInMBs")) {
                this.networkWriteInMBs(model.getNetworkWriteInMBs());
            }
            return this;
        }
    }
}

