/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.HostInsightHostRecommendations;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricRecommendationName")
@JsonFilter(value="explicitlySetFilter")
public final class HostStorageRecommendations
extends HostInsightHostRecommendations {
    @JsonProperty(value="unusedInstance")
    private final UnusedInstance unusedInstance;
    @JsonProperty(value="isAbandonedInstance")
    private final Boolean isAbandonedInstance;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostStorageRecommendations(UnusedInstance unusedInstance, Boolean isAbandonedInstance) {
        this.unusedInstance = unusedInstance;
        this.isAbandonedInstance = isAbandonedInstance;
    }

    public UnusedInstance getUnusedInstance() {
        return this.unusedInstance;
    }

    public Boolean getIsAbandonedInstance() {
        return this.isAbandonedInstance;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostStorageRecommendations(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", unusedInstance=").append(String.valueOf((Object)this.unusedInstance));
        sb.append(", isAbandonedInstance=").append(String.valueOf(this.isAbandonedInstance));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostStorageRecommendations)) {
            return false;
        }
        HostStorageRecommendations other = (HostStorageRecommendations)((Object)o);
        return Objects.equals((Object)this.unusedInstance, (Object)other.unusedInstance) && Objects.equals(this.isAbandonedInstance, other.isAbandonedInstance) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.unusedInstance == null ? 43 : this.unusedInstance.hashCode());
        result = result * 59 + (this.isAbandonedInstance == null ? 43 : this.isAbandonedInstance.hashCode());
        return result;
    }

    public static enum UnusedInstance implements BmcEnum
    {
        InUse("IN_USE"),
        NotInUse("NOT_IN_USE"),
        IsNotDetermined("IS_NOT_DETERMINED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UnusedInstance> map;

        private UnusedInstance(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UnusedInstance create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UnusedInstance', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UnusedInstance.class);
            map = new HashMap<String, UnusedInstance>();
            for (UnusedInstance v : UnusedInstance.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="unusedInstance")
        private UnusedInstance unusedInstance;
        @JsonProperty(value="isAbandonedInstance")
        private Boolean isAbandonedInstance;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder unusedInstance(UnusedInstance unusedInstance) {
            this.unusedInstance = unusedInstance;
            this.__explicitlySet__.add("unusedInstance");
            return this;
        }

        public Builder isAbandonedInstance(Boolean isAbandonedInstance) {
            this.isAbandonedInstance = isAbandonedInstance;
            this.__explicitlySet__.add("isAbandonedInstance");
            return this;
        }

        public HostStorageRecommendations build() {
            HostStorageRecommendations model = new HostStorageRecommendations(this.unusedInstance, this.isAbandonedInstance);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostStorageRecommendations model) {
            if (model.wasPropertyExplicitlySet("unusedInstance")) {
                this.unusedInstance(model.getUnusedInstance());
            }
            if (model.wasPropertyExplicitlySet("isAbandonedInstance")) {
                this.isAbandonedInstance(model.getIsAbandonedInstance());
            }
            return this;
        }
    }
}

