/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostPerformanceMetricGroup;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostTopProcesses
extends HostPerformanceMetricGroup {
    @JsonProperty(value="pid")
    private final BigDecimal pid;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="memoryUtilizationPercent")
    private final Double memoryUtilizationPercent;
    @JsonProperty(value="cpuUtilizationPercent")
    private final Double cpuUtilizationPercent;
    @JsonProperty(value="cpuUsageInSeconds")
    private final Double cpuUsageInSeconds;
    @JsonProperty(value="command")
    private final String command;
    @JsonProperty(value="virtualMemoryInMBs")
    private final Double virtualMemoryInMBs;
    @JsonProperty(value="physicalMemoryInMBs")
    private final Double physicalMemoryInMBs;
    @JsonProperty(value="startTime")
    private final Date startTime;
    @JsonProperty(value="totalProcesses")
    private final BigDecimal totalProcesses;
    @JsonProperty(value="containerId")
    private final String containerId;
    @JsonProperty(value="diskBytesRead")
    private final Double diskBytesRead;
    @JsonProperty(value="diskBytesWritten")
    private final Double diskBytesWritten;
    @JsonProperty(value="diskIopsRead")
    private final Double diskIopsRead;
    @JsonProperty(value="diskIopsWritten")
    private final Double diskIopsWritten;
    @JsonProperty(value="diskIops")
    private final Double diskIops;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostTopProcesses(Date timeCollected, BigDecimal pid, String userName, Double memoryUtilizationPercent, Double cpuUtilizationPercent, Double cpuUsageInSeconds, String command, Double virtualMemoryInMBs, Double physicalMemoryInMBs, Date startTime, BigDecimal totalProcesses, String containerId, Double diskBytesRead, Double diskBytesWritten, Double diskIopsRead, Double diskIopsWritten, Double diskIops) {
        super(timeCollected);
        this.pid = pid;
        this.userName = userName;
        this.memoryUtilizationPercent = memoryUtilizationPercent;
        this.cpuUtilizationPercent = cpuUtilizationPercent;
        this.cpuUsageInSeconds = cpuUsageInSeconds;
        this.command = command;
        this.virtualMemoryInMBs = virtualMemoryInMBs;
        this.physicalMemoryInMBs = physicalMemoryInMBs;
        this.startTime = startTime;
        this.totalProcesses = totalProcesses;
        this.containerId = containerId;
        this.diskBytesRead = diskBytesRead;
        this.diskBytesWritten = diskBytesWritten;
        this.diskIopsRead = diskIopsRead;
        this.diskIopsWritten = diskIopsWritten;
        this.diskIops = diskIops;
    }

    public BigDecimal getPid() {
        return this.pid;
    }

    public String getUserName() {
        return this.userName;
    }

    public Double getMemoryUtilizationPercent() {
        return this.memoryUtilizationPercent;
    }

    public Double getCpuUtilizationPercent() {
        return this.cpuUtilizationPercent;
    }

    public Double getCpuUsageInSeconds() {
        return this.cpuUsageInSeconds;
    }

    public String getCommand() {
        return this.command;
    }

    public Double getVirtualMemoryInMBs() {
        return this.virtualMemoryInMBs;
    }

    public Double getPhysicalMemoryInMBs() {
        return this.physicalMemoryInMBs;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public BigDecimal getTotalProcesses() {
        return this.totalProcesses;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public Double getDiskBytesRead() {
        return this.diskBytesRead;
    }

    public Double getDiskBytesWritten() {
        return this.diskBytesWritten;
    }

    public Double getDiskIopsRead() {
        return this.diskIopsRead;
    }

    public Double getDiskIopsWritten() {
        return this.diskIopsWritten;
    }

    public Double getDiskIops() {
        return this.diskIops;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostTopProcesses(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", pid=").append(String.valueOf(this.pid));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", memoryUtilizationPercent=").append(String.valueOf(this.memoryUtilizationPercent));
        sb.append(", cpuUtilizationPercent=").append(String.valueOf(this.cpuUtilizationPercent));
        sb.append(", cpuUsageInSeconds=").append(String.valueOf(this.cpuUsageInSeconds));
        sb.append(", command=").append(String.valueOf(this.command));
        sb.append(", virtualMemoryInMBs=").append(String.valueOf(this.virtualMemoryInMBs));
        sb.append(", physicalMemoryInMBs=").append(String.valueOf(this.physicalMemoryInMBs));
        sb.append(", startTime=").append(String.valueOf(this.startTime));
        sb.append(", totalProcesses=").append(String.valueOf(this.totalProcesses));
        sb.append(", containerId=").append(String.valueOf(this.containerId));
        sb.append(", diskBytesRead=").append(String.valueOf(this.diskBytesRead));
        sb.append(", diskBytesWritten=").append(String.valueOf(this.diskBytesWritten));
        sb.append(", diskIopsRead=").append(String.valueOf(this.diskIopsRead));
        sb.append(", diskIopsWritten=").append(String.valueOf(this.diskIopsWritten));
        sb.append(", diskIops=").append(String.valueOf(this.diskIops));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostTopProcesses)) {
            return false;
        }
        HostTopProcesses other = (HostTopProcesses)((Object)o);
        return Objects.equals(this.pid, other.pid) && Objects.equals(this.userName, other.userName) && Objects.equals(this.memoryUtilizationPercent, other.memoryUtilizationPercent) && Objects.equals(this.cpuUtilizationPercent, other.cpuUtilizationPercent) && Objects.equals(this.cpuUsageInSeconds, other.cpuUsageInSeconds) && Objects.equals(this.command, other.command) && Objects.equals(this.virtualMemoryInMBs, other.virtualMemoryInMBs) && Objects.equals(this.physicalMemoryInMBs, other.physicalMemoryInMBs) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.totalProcesses, other.totalProcesses) && Objects.equals(this.containerId, other.containerId) && Objects.equals(this.diskBytesRead, other.diskBytesRead) && Objects.equals(this.diskBytesWritten, other.diskBytesWritten) && Objects.equals(this.diskIopsRead, other.diskIopsRead) && Objects.equals(this.diskIopsWritten, other.diskIopsWritten) && Objects.equals(this.diskIops, other.diskIops) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pid == null ? 43 : this.pid.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.memoryUtilizationPercent == null ? 43 : this.memoryUtilizationPercent.hashCode());
        result = result * 59 + (this.cpuUtilizationPercent == null ? 43 : this.cpuUtilizationPercent.hashCode());
        result = result * 59 + (this.cpuUsageInSeconds == null ? 43 : this.cpuUsageInSeconds.hashCode());
        result = result * 59 + (this.command == null ? 43 : this.command.hashCode());
        result = result * 59 + (this.virtualMemoryInMBs == null ? 43 : this.virtualMemoryInMBs.hashCode());
        result = result * 59 + (this.physicalMemoryInMBs == null ? 43 : this.physicalMemoryInMBs.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.totalProcesses == null ? 43 : this.totalProcesses.hashCode());
        result = result * 59 + (this.containerId == null ? 43 : this.containerId.hashCode());
        result = result * 59 + (this.diskBytesRead == null ? 43 : this.diskBytesRead.hashCode());
        result = result * 59 + (this.diskBytesWritten == null ? 43 : this.diskBytesWritten.hashCode());
        result = result * 59 + (this.diskIopsRead == null ? 43 : this.diskIopsRead.hashCode());
        result = result * 59 + (this.diskIopsWritten == null ? 43 : this.diskIopsWritten.hashCode());
        result = result * 59 + (this.diskIops == null ? 43 : this.diskIops.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="pid")
        private BigDecimal pid;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="memoryUtilizationPercent")
        private Double memoryUtilizationPercent;
        @JsonProperty(value="cpuUtilizationPercent")
        private Double cpuUtilizationPercent;
        @JsonProperty(value="cpuUsageInSeconds")
        private Double cpuUsageInSeconds;
        @JsonProperty(value="command")
        private String command;
        @JsonProperty(value="virtualMemoryInMBs")
        private Double virtualMemoryInMBs;
        @JsonProperty(value="physicalMemoryInMBs")
        private Double physicalMemoryInMBs;
        @JsonProperty(value="startTime")
        private Date startTime;
        @JsonProperty(value="totalProcesses")
        private BigDecimal totalProcesses;
        @JsonProperty(value="containerId")
        private String containerId;
        @JsonProperty(value="diskBytesRead")
        private Double diskBytesRead;
        @JsonProperty(value="diskBytesWritten")
        private Double diskBytesWritten;
        @JsonProperty(value="diskIopsRead")
        private Double diskIopsRead;
        @JsonProperty(value="diskIopsWritten")
        private Double diskIopsWritten;
        @JsonProperty(value="diskIops")
        private Double diskIops;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder pid(BigDecimal pid) {
            this.pid = pid;
            this.__explicitlySet__.add("pid");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder memoryUtilizationPercent(Double memoryUtilizationPercent) {
            this.memoryUtilizationPercent = memoryUtilizationPercent;
            this.__explicitlySet__.add("memoryUtilizationPercent");
            return this;
        }

        public Builder cpuUtilizationPercent(Double cpuUtilizationPercent) {
            this.cpuUtilizationPercent = cpuUtilizationPercent;
            this.__explicitlySet__.add("cpuUtilizationPercent");
            return this;
        }

        public Builder cpuUsageInSeconds(Double cpuUsageInSeconds) {
            this.cpuUsageInSeconds = cpuUsageInSeconds;
            this.__explicitlySet__.add("cpuUsageInSeconds");
            return this;
        }

        public Builder command(String command) {
            this.command = command;
            this.__explicitlySet__.add("command");
            return this;
        }

        public Builder virtualMemoryInMBs(Double virtualMemoryInMBs) {
            this.virtualMemoryInMBs = virtualMemoryInMBs;
            this.__explicitlySet__.add("virtualMemoryInMBs");
            return this;
        }

        public Builder physicalMemoryInMBs(Double physicalMemoryInMBs) {
            this.physicalMemoryInMBs = physicalMemoryInMBs;
            this.__explicitlySet__.add("physicalMemoryInMBs");
            return this;
        }

        public Builder startTime(Date startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder totalProcesses(BigDecimal totalProcesses) {
            this.totalProcesses = totalProcesses;
            this.__explicitlySet__.add("totalProcesses");
            return this;
        }

        public Builder containerId(String containerId) {
            this.containerId = containerId;
            this.__explicitlySet__.add("containerId");
            return this;
        }

        public Builder diskBytesRead(Double diskBytesRead) {
            this.diskBytesRead = diskBytesRead;
            this.__explicitlySet__.add("diskBytesRead");
            return this;
        }

        public Builder diskBytesWritten(Double diskBytesWritten) {
            this.diskBytesWritten = diskBytesWritten;
            this.__explicitlySet__.add("diskBytesWritten");
            return this;
        }

        public Builder diskIopsRead(Double diskIopsRead) {
            this.diskIopsRead = diskIopsRead;
            this.__explicitlySet__.add("diskIopsRead");
            return this;
        }

        public Builder diskIopsWritten(Double diskIopsWritten) {
            this.diskIopsWritten = diskIopsWritten;
            this.__explicitlySet__.add("diskIopsWritten");
            return this;
        }

        public Builder diskIops(Double diskIops) {
            this.diskIops = diskIops;
            this.__explicitlySet__.add("diskIops");
            return this;
        }

        public HostTopProcesses build() {
            HostTopProcesses model = new HostTopProcesses(this.timeCollected, this.pid, this.userName, this.memoryUtilizationPercent, this.cpuUtilizationPercent, this.cpuUsageInSeconds, this.command, this.virtualMemoryInMBs, this.physicalMemoryInMBs, this.startTime, this.totalProcesses, this.containerId, this.diskBytesRead, this.diskBytesWritten, this.diskIopsRead, this.diskIopsWritten, this.diskIops);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostTopProcesses model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("pid")) {
                this.pid(model.getPid());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("memoryUtilizationPercent")) {
                this.memoryUtilizationPercent(model.getMemoryUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuUtilizationPercent")) {
                this.cpuUtilizationPercent(model.getCpuUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuUsageInSeconds")) {
                this.cpuUsageInSeconds(model.getCpuUsageInSeconds());
            }
            if (model.wasPropertyExplicitlySet("command")) {
                this.command(model.getCommand());
            }
            if (model.wasPropertyExplicitlySet("virtualMemoryInMBs")) {
                this.virtualMemoryInMBs(model.getVirtualMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("physicalMemoryInMBs")) {
                this.physicalMemoryInMBs(model.getPhysicalMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("totalProcesses")) {
                this.totalProcesses(model.getTotalProcesses());
            }
            if (model.wasPropertyExplicitlySet("containerId")) {
                this.containerId(model.getContainerId());
            }
            if (model.wasPropertyExplicitlySet("diskBytesRead")) {
                this.diskBytesRead(model.getDiskBytesRead());
            }
            if (model.wasPropertyExplicitlySet("diskBytesWritten")) {
                this.diskBytesWritten(model.getDiskBytesWritten());
            }
            if (model.wasPropertyExplicitlySet("diskIopsRead")) {
                this.diskIopsRead(model.getDiskIopsRead());
            }
            if (model.wasPropertyExplicitlySet("diskIopsWritten")) {
                this.diskIopsWritten(model.getDiskIopsWritten());
            }
            if (model.wasPropertyExplicitlySet("diskIops")) {
                this.diskIops(model.getDiskIops());
            }
            return this;
        }
    }
}

